/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.events.gameplay.PlayerExecuteSkillEvent;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.MorphStrings;
import xyz.nifeather.morph.messages.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.permissions.CommonPermissions;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSkillCooldownCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.skills.CooldownManager;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.impl.NoneMorphSkill;
import xyz.nifeather.morph.skills.options.NoOpConfiguration;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.utilities.PermissionUtils;

public class SkillUpdater
extends MorphPluginObject {
    private final DisguiseState state;
    @NotNull
    private volatile ISkill<?> skill = NoneMorphSkill.instance;
    @NotNull
    private volatile ISkillAbilityOption skillOption = NoOpConfiguration.instance;
    private volatile long availableAfter;
    public volatile int defaultSkillCooldown = 20;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;

    public ISkill<?> getBindingSkill() {
        return this.skill;
    }

    public long getAvailableAfter() {
        return this.availableAfter;
    }

    public void setAvailableAfter(long val, boolean notifyClient) {
        this.availableAfter = val;
        if (notifyClient) {
            this.applyCooldownToClient();
        }
    }

    public SkillUpdater(DisguiseState bindingState) {
        this.state = bindingState;
    }

    public void update() {
    }

    public void onPlayerJoin() {
        this.skill.onInitialEquip(this.state);
    }

    public boolean executeSkillCheckPermission() {
        Player player = this.state.getPlayer();
        if (!player.hasPermission("feathermorph.skill")) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.noPermissionMessage()));
            return false;
        }
        if (!this.state.canActivateSkill()) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, SkillStrings.skillNotAvailableString()));
            return false;
        }
        if (player.getGameMode() == GameMode.SPECTATOR || this.skill == NoneMorphSkill.instance) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, SkillStrings.skillNotAvaliableString()));
            player.playSound(Sound.sound((Key)Key.key((String)"minecraft", (String)"entity.villager.no"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f));
            return false;
        }
        String singleSkillPerm = CommonPermissions.skillPermissionOf(this.skill.getIdentifier().asString(), this.state.getDisguiseIdentifier());
        boolean hasSkillPerm = PermissionUtils.hasPermission(player, singleSkillPerm, true);
        if (!hasSkillPerm) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.noPermissionMessage()));
            player.playSound(Sound.sound((Key)Key.key((String)"minecraft", (String)"entity.villager.no"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f));
            this.state.setSkillCooldown(5L, true);
            return false;
        }
        if (this.plugin.getCurrentTick() < this.availableAfter) {
            long delta = this.availableAfter - this.plugin.getCurrentTick();
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, SkillStrings.skillPreparing().resolve("time", "" + Math.round((float)delta / 20.0f))));
            player.playSound(Sound.sound((Key)Key.key((String)"minecraft", (String)"entity.villager.no"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f));
            return false;
        }
        return this.executeSkill();
    }

    public boolean executeSkill() {
        Player player = this.state.getPlayer();
        PlayerExecuteSkillEvent event = new PlayerExecuteSkillEvent(player, this.state);
        if (event.isCancelled()) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, MorphStrings.operationCancelledString()));
            this.setCooldown(5L, true);
            return false;
        }
        ISkill<?> skill = this.skill;
        int cooldown = 0;
        try {
            int cd = skill.executeSkill(player, this.state, this.skillOption);
            cooldown = cd > 0 ? cd : this.state.getDefaultSkillCooldown();
        }
        catch (ExecutionErrorException e) {
            this.logger.error("Error executing skill", (Throwable)e);
            Component component = MessageUtils.prefixes((CommandSender)player, SkillStrings.exceptionOccurredString()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)e.getMessage())));
            player.playSound(Sound.sound((Key)Key.key((String)"minecraft", (String)"entity.villager.no"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f));
            player.sendMessage(component);
            cooldown = 20;
        }
        this.setCooldown(cooldown, true);
        return true;
    }

    public void setCooldown(long cooldown, boolean notifyClient) {
        this.availableAfter = this.plugin.getCurrentTick() + cooldown;
        if (notifyClient) {
            this.applyCooldownToClient();
        }
    }

    public long calculateRemainingCooldown() {
        return Math.max(0L, this.availableAfter - this.plugin.getCurrentTick());
    }

    public void applyCooldownToClient() {
        this.clientHandler.sendCommand(this.state.getPlayer(), (AbstractS2CCommand<?>)new S2CSetSkillCooldownCommand(this.calculateRemainingCooldown()));
    }

    public void submitCooldown(CooldownManager cooldownManager) {
        cooldownManager.submit(this.state.getPlayerUUID(), this.state.getDisguiseIdentifier(), this.availableAfter);
    }

    public <O extends ISkillAbilityOption> void bindSkill(ISkill<O> newSkill, O option) {
        this.skill.onDeEquip(this.state);
        if (newSkill == null) {
            newSkill = NoneMorphSkill.instance;
        }
        if (option == null) {
            option = NoOpConfiguration.instance;
        }
        this.skill = newSkill;
        this.skillOption = option;
        newSkill.onInitialEquip(this.state);
    }
}

