/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.skills.MorphSkill;
import xyz.nifeather.morph.skills.options.NoOpConfiguration;

public class SplashPotionSkill
extends MorphSkill<NoOpConfiguration> {
    private final PotionInfo[] validTypes = new PotionInfo[]{PotionInfo.of(PotionEffectType.REGENERATION, 900, 0), PotionInfo.of(PotionEffectType.REGENERATION, 20, 0), PotionInfo.of(PotionEffectType.SLOWNESS, 1800, 0), PotionInfo.of(PotionEffectType.POISON, 900, 0), PotionInfo.of(PotionEffectType.WEAKNESS, 1800, 0), PotionInfo.of(PotionEffectType.INSTANT_DAMAGE, 20, 0)};

    @Override
    public ISkillAbilityOptionHandler<NoOpConfiguration> optionHandler() {
        return NoOpConfiguration.OPTION_HANDLER;
    }

    @Override
    public int executeSkill(Player player, DisguiseState state, NoOpConfiguration option) throws ExecutionErrorException {
        Object launchedProjectile = this.launchProjectile(player, EntityType.SPLASH_POTION, 0.4f);
        if (launchedProjectile == null) {
            throw ExecutionErrorException.forMethod("executeSkill").withMessage("Unable to spawn entity").create();
        }
        if (!(launchedProjectile instanceof ThrownPotion)) {
            throw ExecutionErrorException.forMethod("executeSkill").withMessage("Error summoning splash potion: Excepted ThrownPotion, but got %s".formatted(launchedProjectile.getClass())).create();
        }
        ThrownPotion thrownPotion = (ThrownPotion)launchedProjectile;
        PotionMeta meta = thrownPotion.getPotionMeta();
        PotionInfo info = this.validTypes[ThreadLocalRandom.current().nextInt(0, this.validTypes.length)];
        PotionEffect potionEffect = new PotionEffect(info.type, info.duration, info.amplifier, false, true);
        meta.addCustomEffect(potionEffect, true);
        meta.setColor(info.type().getColor());
        thrownPotion.setPotionMeta(meta);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WITCH_THROW, 1.0f, 1.0f);
        return 0;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.WITCH;
    }

    private record PotionInfo(PotionEffectType type, int duration, int amplifier) {
        public static PotionInfo of(PotionEffectType type, int duration, int amp) {
            return new PotionInfo(type, duration, amp);
        }
    }
}

