/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.storage.playerdata;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.storage.MorphJsonBasedStorage;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;
import xyz.nifeather.morph.storage.playerdata.PlayerMetaContainer;

@Deprecated(forRemoval=true)
public class LegacyPlayerDataStore
extends MorphJsonBasedStorage<PlayerMetaContainer>
implements IManagePlayerData {
    private final List<DisguiseMeta> cachedMetas = new CopyOnWriteArrayList<DisguiseMeta>();
    private final int targetConfigurationVersion = 4;

    public File file() {
        return this.configurationFile;
    }

    @Override
    @NotNull
    protected String getFileName() {
        return "data.json";
    }

    @Override
    @NotNull
    protected PlayerMetaContainer createDefault() {
        return new PlayerMetaContainer();
    }

    @Override
    @NotNull
    protected String getDisplayName() {
        return "\u6570\u636e\u5b58\u50a8";
    }

    @Override
    public boolean reloadConfiguration() {
        boolean success = super.reloadConfiguration();
        if (!success) {
            return false;
        }
        if (((PlayerMetaContainer)this.storingObject).Version < 4) {
            this.migrate((PlayerMetaContainer)this.storingObject);
        }
        this.getAll().forEach(c -> {
            ObjectArrayList list = new ObjectArrayList();
            ObjectArrayList unlockedDisguiseIdentifiers = new ObjectArrayList(c.getUnlockedDisguiseIdentifiers());
            unlockedDisguiseIdentifiers.sort(null);
            unlockedDisguiseIdentifiers.forEach(i -> {
                DisguiseTypes type = DisguiseTypes.fromId(i);
                if (type != null) {
                    list.add((Object)new DisguiseMeta((String)i, DisguiseTypes.fromId(i)));
                } else {
                    this.logger.warn("Unknown entity identifier: " + i);
                }
            });
            c.setUnlockedDisguises((ObjectArrayList<DisguiseMeta>)list);
        });
        return true;
    }

    @Override
    public void shouldLoadAllData(boolean shouldLoadAllData) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public List<PlayerMeta> listAll() {
        throw new RuntimeException("Not implemented");
    }

    private void migrate(PlayerMetaContainer configuration) {
        if (configuration.Version < 2) {
            configuration.playerMetas.forEach(c -> {
                if (Objects.equals(c.playerName, "Unknown")) {
                    c.playerName = null;
                }
            });
        }
        if (configuration.Version < 3) {
            configuration.playerMetas.forEach(c -> {
                ObjectArrayList list = new ObjectArrayList();
                c.getUnlockedDisguises().forEach(i -> {
                    if (i.getDisguiseType() == DisguiseTypes.UNKNOWN) {
                        this.logger.warn("Invalid entity identifier: " + String.valueOf(i));
                        return;
                    }
                    list.add((Object)i.getKey());
                });
                c.setUnlockedDisguiseIdentifiers((List<String>)list);
                c.setUnlockedDisguises(null);
            });
        }
        if (configuration.Version < 4) {
            configuration.playerMetas.forEach(c -> {
                ObjectArrayList list = new ObjectArrayList();
                c.getUnlockedDisguiseIdentifiers().forEach(s -> {
                    if (!s.startsWith("ld:")) {
                        list.add(s);
                    } else {
                        list.add((Object)s.replaceFirst("ld:", "local:"));
                    }
                });
                c.setUnlockedDisguiseIdentifiers((List<String>)list);
            });
        }
        configuration.Version = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PlayerMeta getPlayerMeta(OfflinePlayer player) {
        PlayerMeta value = this.getAll().stream().filter(c -> c.uniqueId.equals(player.getUniqueId())).findFirst().orElse(null);
        if (value != null) {
            if (value.playerName == null) {
                value.playerName = player.getName();
            }
            return value;
        }
        PlayerMeta newInstance = new PlayerMeta();
        newInstance.uniqueId = player.getUniqueId();
        newInstance.playerName = player.getName();
        LegacyPlayerDataStore legacyPlayerDataStore = this;
        synchronized (legacyPlayerDataStore) {
            ((PlayerMetaContainer)this.storingObject).playerMetas.add(newInstance);
        }
        return newInstance;
    }

    @Override
    public boolean grantMorphToPlayer(Player player, String disguiseIdentifier) {
        PlayerMeta playerConfiguration = this.getPlayerMeta((OfflinePlayer)player);
        DisguiseMeta meta = this.getDisguiseMeta(disguiseIdentifier);
        if (meta == null) {
            return false;
        }
        if (!playerConfiguration.getUnlockedDisguises().stream().noneMatch(c -> c.equals(meta))) {
            return false;
        }
        playerConfiguration.addDisguise(meta);
        this.saveConfiguration();
        return true;
    }

    @Override
    public boolean revokeMorphFromPlayer(Player player, String disguiseIdentifier) {
        List<DisguiseMeta> avaliableDisguises = this.getAvaliableDisguisesFor(player);
        DisguiseMeta meta = avaliableDisguises.stream().filter(d -> d.equals(disguiseIdentifier)).findFirst().orElse(null);
        if (meta == null) {
            return false;
        }
        this.getPlayerMeta((OfflinePlayer)player).removeDisguise(meta);
        this.saveConfiguration();
        return true;
    }

    @Override
    @Nullable
    public DisguiseMeta getDisguiseMeta(String rawString) {
        DisguiseTypes type = DisguiseTypes.fromId(rawString);
        if (this.cachedMetas.stream().noneMatch(o -> o.equals(rawString))) {
            this.cachedMetas.add(new DisguiseMeta(rawString, type));
        }
        return this.cachedMetas.stream().filter(o -> o.equals(rawString)).findFirst().orElse(null);
    }

    @Override
    public List<DisguiseMeta> getAvaliableDisguisesFor(Player player) {
        return this.getPlayerMeta((OfflinePlayer)player).getUnlockedDisguises();
    }

    public synchronized List<PlayerMeta> getAll() {
        return new ObjectArrayList(((PlayerMetaContainer)this.storingObject).playerMetas);
    }
}

