/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.updates;

public class VersionHandling {
    public static VersionInfo toVersionInfo(String versionString) {
        int patch;
        if (versionString == null || versionString.equals("null") || versionString.isBlank()) {
            return VersionInfo.INVALID_VERSION;
        }
        String[] vers = versionString.split("-", 2);
        String[] strSpilt = vers[0].split("\\.");
        int major = strSpilt.length >= 1 ? VersionHandling.tryParse(strSpilt[0]) : 0;
        int minor = strSpilt.length >= 2 ? VersionHandling.tryParse(strSpilt[1]) : 0;
        int n = patch = strSpilt.length >= 3 ? VersionHandling.tryParse(strSpilt[2]) : 0;
        String channel = vers.length > 2 ? vers[1] : (strSpilt.length >= 4 ? strSpilt[3] : "DefaultRelease");
        return new VersionInfo(major, minor, patch, channel);
    }

    private static int tryParse(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public record VersionInfo(int major, int minor, int patch, String channel) {
        public static VersionInfo INVALID_VERSION = new VersionInfo(0, 0, 0, "Invalid");

        @Override
        public String toString() {
            return "%s.%s.%s.%s".formatted(this.major, this.minor, this.patch, this.channel);
        }

        public boolean isInvalid() {
            return this.equals(INVALID_VERSION);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof VersionInfo)) {
                return false;
            }
            VersionInfo other = (VersionInfo)o;
            return this.major == other.major && this.minor == other.minor && this.patch == other.patch && this.channel.equalsIgnoreCase(other.channel);
        }

        public CompareResult compare(VersionInfo input) {
            if (input.major == this.major && input.minor == this.minor && input.patch == this.patch) {
                if (input.channel.equals(this.channel)) {
                    return CompareResult.EQUAL;
                }
                return CompareResult.NOT_ON_SAME_CHANNEL;
            }
            if (input.major > this.major) {
                return CompareResult.INPUT_NEWER;
            }
            if (input.major < this.major) {
                return CompareResult.INPUT_OLDER;
            }
            if (input.minor > this.minor) {
                return CompareResult.INPUT_NEWER;
            }
            if (input.minor < this.minor) {
                return CompareResult.INPUT_OLDER;
            }
            if (input.patch > this.patch) {
                return CompareResult.INPUT_NEWER;
            }
            return CompareResult.INPUT_OLDER;
        }
    }

    public static enum CompareResult {
        EQUAL,
        INPUT_NEWER,
        INPUT_OLDER,
        NOT_ON_SAME_CHANNEL;

    }
}

