/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.C2S;

import xyz.nifeather.fmccl.network.BasicClientHandler;
import xyz.nifeather.fmccl.network.annotations.Environment;
import xyz.nifeather.fmccl.network.annotations.EnvironmentType;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;

public class NetheriteC2SToggleSelfCommand
extends NetheriteC2SCommand<SelfViewMode> {
    public NetheriteC2SToggleSelfCommand(SelfViewMode val) {
        super(val);
    }

    public SelfViewMode getSelfViewMode() {
        return (SelfViewMode)((Object)this.getArgumentAt(0));
    }

    @Override
    public String getBaseName() {
        return "toggleself";
    }

    @Override
    @Environment(value=EnvironmentType.SERVER)
    public void onCommand(BasicClientHandler<?> listener) {
        listener.onToggleSelfCommand(this);
    }

    public static enum SelfViewMode {
        ON("true"),
        OFF("false"),
        CLIENT_ON("client true"),
        CLIENT_OFF("client false");

        private final String networkName;

        public static SelfViewMode fromBoolean(boolean value) {
            return value ? ON : OFF;
        }

        public static SelfViewMode fromString(String str) {
            if (str.equalsIgnoreCase("true")) {
                return ON;
            }
            if (str.equalsIgnoreCase("false")) {
                return OFF;
            }
            if (str.equalsIgnoreCase("client true")) {
                return CLIENT_ON;
            }
            if (str.equalsIgnoreCase("client false")) {
                return CLIENT_OFF;
            }
            return OFF;
        }

        private SelfViewMode(String networkName) {
            this.networkName = networkName;
        }

        public String toString() {
            return this.networkName;
        }
    }
}

