/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.processor;

import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SAnimationCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SInitialCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SMorphCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SOptionCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SRequestCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SSkillCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SToggleSelfCommand;
import xyz.nifeather.fmccl.network.commands.C2S.NetheriteC2SUnmorphCommand;
import xyz.nifeather.fmccl.network.commands.CommandRegistries;

public class C2SCommandProcessor {
    private final CommandRegistries registries = new CommandRegistries();

    public C2SCommandProcessor() {
        this.registries.registerC2S("initial", a -> new NetheriteC2SInitialCommand()).registerC2S("morph", NetheriteC2SMorphCommand::new).registerC2S("skill", a -> new NetheriteC2SSkillCommand()).registerC2S("option", NetheriteC2SOptionCommand::fromString).registerC2S("toggleself", a -> new NetheriteC2SToggleSelfCommand(NetheriteC2SToggleSelfCommand.SelfViewMode.fromString(a))).registerC2S("unmorph", a -> new NetheriteC2SUnmorphCommand()).registerC2S("request", NetheriteC2SRequestCommand::new).registerC2S("animation", NetheriteC2SAnimationCommand::new);
    }

    public NetheriteC2SCommand<?> processLegacyCommandLine(String commandLine) throws RuntimeException {
        String[] str = commandLine.split(" ", 2);
        if (str.length < 1) {
            throw new RuntimeException("Incomplete server command: " + commandLine);
        }
        String baseCommand = str[0];
        NetheriteC2SCommand<?> c2sCommand = this.registries.createC2SCommand(baseCommand, str.length == 2 ? str[1] : "");
        if (c2sCommand == null) {
            throw new RuntimeException("Unknown server command for name '%s'".formatted(baseCommand));
        }
        return c2sCommand;
    }
}

