/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.WrapperEvent;

public abstract class EventWrapper<TInstance>
extends DisguiseWrapper<TInstance> {
    protected final Map<WrapperEvent<?>, List<ActionRecord<?>>> eventListMap = new Object2ObjectArrayMap();

    public EventWrapper(@NotNull TInstance tInstance, DisguiseBackend<TInstance, ? extends DisguiseWrapper<TInstance>> backend) {
        super(tInstance, backend);
    }

    protected <T> void callEvent(WrapperEvent<T> wrapperEvent, T value) {
        List list = this.eventListMap.getOrDefault(wrapperEvent, null);
        if (list == null) {
            return;
        }
        list.forEach(ar -> ar.consumer().accept(value));
    }

    @Override
    public <T> void subscribeEvent(Object source, WrapperEvent<T> wrapperEvent, Consumer<T> c) {
        List list = this.eventListMap.getOrDefault(wrapperEvent, null);
        if (list == null) {
            list = new ObjectArrayList();
            this.eventListMap.put(wrapperEvent, list);
        }
        if (list.stream().noneMatch(ar -> Objects.equals(ar.source(), source))) {
            list.add(new ActionRecord<T>(source, c));
        }
    }

    @Override
    public void unSubscribeEvent(Object source, WrapperEvent<?> wrapperEvent) {
        List list = this.eventListMap.getOrDefault(wrapperEvent, null);
        if (list == null) {
            return;
        }
        list.removeIf(ar -> Objects.equals(ar.source(), source));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventListMap.clear();
    }

    public record ActionRecord<T>(Object source, Consumer<T> consumer) {
    }
}

