/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.client;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.EventWrapper;
import xyz.nifeather.morph.backends.WrapperEvent;
import xyz.nifeather.morph.backends.WrapperProperties;
import xyz.nifeather.morph.backends.client.ModBackend;
import xyz.nifeather.morph.backends.client.TrackingClientDisguise;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.OffTreeProperties;

public class ModDisguiseWrapper
extends EventWrapper<TrackingClientDisguise> {
    private final UUID waypointUUID;
    private final ModBackend backend;
    private static final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
    @Nullable
    private Player bindingPlayer;

    public ModDisguiseWrapper(@NotNull TrackingClientDisguise instance, ModBackend backend) {
        super(instance, backend);
        this.backend = backend;
        this.waypointUUID = UUID.randomUUID();
    }

    @Override
    @NotNull
    public UUID getVirtualEntityUUID() {
        UUID val = this.readPropertyOr(OffTreeProperties.VIRTUAL_ENTITY_UUID, null);
        return Objects.requireNonNull(val, "VirtualEntityUUID is not set for an instance of ModDisguiseWrapper");
    }

    @Override
    public Map<SingleProperty<?>, Object> getProperties() {
        return new Object2ObjectOpenHashMap(((TrackingClientDisguise)this.instance).disguiseProperties());
    }

    @Override
    public <X> void writeProperty(SingleProperty<X> property, X value) {
        ((TrackingClientDisguise)this.instance).writeProperty(property, value);
        if (property.equals(WrapperProperties.PROFILE)) {
            GameProfile val = ((Optional)value).orElse(null);
            this.callEvent(WrapperEvent.SKIN_SET, val);
            return;
        }
        if (property.equals(OffTreeProperties.DISPLAY_FAKE_EQUIPMENT) && this.getBindingPlayer() != null) {
            this.backend.getNetworkingHelper().prepareMeta((Entity)this.getBindingPlayer()).setDisguiseEquipmentShown(Boolean.TRUE.equals(value)).send();
            return;
        }
    }

    @Override
    @NotNull
    public <X> X readProperty(SingleProperty<X> property) {
        return ((TrackingClientDisguise)this.instance).readProperty(property);
    }

    @Override
    public <X> X readPropertyOr(SingleProperty<X> property, X defaultVal) {
        return ((TrackingClientDisguise)this.instance).readPropertyOr(property, defaultVal);
    }

    @Override
    public <X> X readPropertyOrThrow(SingleProperty<X> property) {
        return ((TrackingClientDisguise)this.instance).readPropertyOrThrow(property);
    }

    @Override
    public EntityEquipment getFakeEquipments() {
        return ((TrackingClientDisguise)this.instance).equipment();
    }

    @Override
    public void setFakeEquipments(@NotNull EntityEquipment newEquipment) {
        ((TrackingClientDisguise)this.instance).equipment().setArmorContents(newEquipment.getArmorContents());
        ((TrackingClientDisguise)this.instance).equipment().setHandItems(newEquipment.getItemInMainHand(), newEquipment.getItemInOffHand());
    }

    @Override
    public void setServerSelfView(boolean enabled) {
    }

    @Override
    public EntityType getEntityType() {
        return ((TrackingClientDisguise)this.instance).entityType();
    }

    @Override
    public TrackingClientDisguise copyInstance() {
        return ((TrackingClientDisguise)this.instance).clone();
    }

    @Override
    public DisguiseWrapper<TrackingClientDisguise> clone() {
        ModDisguiseWrapper newWrapper = new ModDisguiseWrapper(this.copyInstance(), (ModBackend)this.getBackend());
        ((TrackingClientDisguise)newWrapper.instance).disguiseProperties().putAll(((TrackingClientDisguise)this.instance).disguiseProperties());
        return newWrapper;
    }

    public static ModDisguiseWrapper fromExternal(DisguiseWrapper<?> other, ModBackend backend) {
        ModDisguiseWrapper newWrapper = new ModDisguiseWrapper(new TrackingClientDisguise(other.getEntityType()), backend);
        ((TrackingClientDisguise)newWrapper.instance).disguiseProperties().putAll(other.getProperties());
        return newWrapper;
    }

    @Override
    public boolean isBaby() {
        return false;
    }

    @Override
    public void postBuildDisguise(DisguiseState state, @Nullable Entity targetEntity) {
    }

    @Override
    public void update(DisguiseState state, Player player) {
    }

    @Override
    public CompoundTag getCompound() {
        return new CompoundTag();
    }

    @Nullable
    public Player getBindingPlayer() {
        return this.bindingPlayer;
    }

    public void setBindingPlayer(@Nullable Player player) {
        this.bindingPlayer = player;
    }
}

