/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class TrackingClientDisguise
implements Cloneable {
    private final DisguiseEquipment equipment = new DisguiseEquipment();
    private EntityType entityType;
    private final Map<SingleProperty<?>, Object> disguiseProperties = new ConcurrentHashMap();

    public TrackingClientDisguise(EntityType type) {
        this.entityType = type;
    }

    public DisguiseEquipment equipment() {
        return this.equipment;
    }

    public EntityType entityType() {
        return this.entityType;
    }

    public Map<SingleProperty<?>, Object> disguiseProperties() {
        return this.disguiseProperties;
    }

    public <X> void writeProperty(SingleProperty<X> property, X value) {
        this.disguiseProperties.put(property, value);
    }

    @NotNull
    public <X> X readProperty(SingleProperty<X> property) {
        return this.readPropertyOr(property, property.defaultVal());
    }

    public <X> X readPropertyOr(SingleProperty<X> property, X defaultVal) {
        return (X)this.disguiseProperties.getOrDefault(property, defaultVal);
    }

    public <X> X readPropertyOrThrow(SingleProperty<X> property) {
        X val = this.disguiseProperties.getOrDefault(property, null);
        if (val == null) {
            throw new NullDependencyException("The requested property '%s' was not found in %s".formatted(property.id(), this));
        }
        return val;
    }

    protected TrackingClientDisguise clone() {
        TrackingClientDisguise obj;
        try {
            obj = (TrackingClientDisguise)super.clone();
        }
        catch (Throwable t) {
            obj = new TrackingClientDisguise(this.entityType());
        }
        return obj;
    }
}

