/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.server.ServerDisguise;
import xyz.nifeather.morph.backends.server.ServerDisguiseWrapper;
import xyz.nifeather.morph.backends.server.renderer.ServerRenderer;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.utilties.WatcherUtils;
import xyz.nifeather.morph.messages.BackendStrings;
import xyz.nifeather.morph.misc.BuildFailedException;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class ServerBackend
extends DisguiseBackend<ServerDisguise, ServerDisguiseWrapper> {
    private static ServerBackend instance;
    public final ServerRenderer serverRenderer;
    private final Map<UUID, ServerDisguiseWrapper> disguiseWrapperMap = new Object2ObjectOpenHashMap();

    @javax.annotation.Nullable
    public static ServerBackend getInstance() {
        return instance;
    }

    public ServerBackend() {
        instance = this;
        this.serverRenderer = new ServerRenderer();
    }

    @Override
    public void dispose() {
        this.serverRenderer.dispose();
    }

    @Override
    public String getIdentifier() {
        return "server";
    }

    @Override
    public FormattableMessage getDisplayName() {
        return BackendStrings.serverBackendName();
    }

    @Override
    public DisguiseWrapper<ServerDisguise> createInstance(EntityType entityType) {
        return new ServerDisguiseWrapper(new ServerDisguise(entityType), this);
    }

    @Override
    public DisguiseWrapper<ServerDisguise> createPlayerInstance(String targetPlayerName) {
        ServerDisguiseWrapper wrapper = new ServerDisguiseWrapper(new ServerDisguise(EntityType.PLAYER), this);
        wrapper.setDisguiseName(targetPlayerName);
        return wrapper;
    }

    @Override
    public ServerDisguise createRawInstance(Entity entity) {
        return new ServerDisguise(entity.getType());
    }

    @Override
    public boolean isDisguised(@Nullable Entity target) {
        if (target == null) {
            return false;
        }
        return this.disguiseWrapperMap.containsKey(target.getUniqueId());
    }

    @Override
    @javax.annotation.Nullable
    public ServerDisguiseWrapper getWrapper(Entity target) {
        return this.disguiseWrapperMap.getOrDefault(target.getUniqueId(), null);
    }

    @Override
    @NotNull
    public ServerDisguiseWrapper cloneWrapperFrom(DisguiseWrapper<?> otherWrapper) {
        ServerDisguiseWrapper serverDisguiseWrapper;
        if (otherWrapper instanceof ServerDisguiseWrapper) {
            ServerDisguiseWrapper serverDisguiseWrapper2 = (ServerDisguiseWrapper)otherWrapper;
            serverDisguiseWrapper = this.cloneWrapper(serverDisguiseWrapper2);
        } else {
            serverDisguiseWrapper = this.cloneOther(otherWrapper);
        }
        return serverDisguiseWrapper;
    }

    private ServerDisguiseWrapper cloneWrapper(ServerDisguiseWrapper other) {
        return (ServerDisguiseWrapper)other.clone();
    }

    private ServerDisguiseWrapper cloneOther(DisguiseWrapper<?> other) {
        return ServerDisguiseWrapper.cloneFromExternal(other, this);
    }

    @Override
    public void disguise(Player player, DisguiseWrapper<?> wrapper) throws ExecutionErrorException {
        if (!(wrapper instanceof ServerDisguiseWrapper)) {
            throw ExecutionErrorException.forMethod("ServerBackend#disguise").withMessage("The given disguise wrapper is not an instance of ServerDisguiseWrapper.").create();
        }
        ServerDisguiseWrapper serverDisguiseWrapper = (ServerDisguiseWrapper)wrapper;
        if (this.disguiseWrapperMap.containsKey(player.getUniqueId())) {
            this.unDisguise(player, false);
        }
        this.disguiseWrapperMap.put(player.getUniqueId(), serverDisguiseWrapper);
        SingleWatcher watcher = this.serverRenderer.registerEntity(player, wrapper.getEntityType(), wrapper.getDisguiseName());
        watcher.markSilent(this);
        serverDisguiseWrapper.setRenderParameters(player, watcher);
        watcher.unmarkSilent(this);
        try {
            this.serverRenderer.refreshStateForPlayer(player, WatcherUtils.getAffectedPlayers(player));
        }
        catch (NullDependencyException e) {
            throw ExecutionErrorException.forMethod("ServerBackend#disguise").causedBy(e).withMessage("Failed to refresh player state, watcher not registered in the renderer!").create();
        }
        catch (BuildFailedException e) {
            throw ExecutionErrorException.forMethod("ServerBackend#disguise").causedBy(e).withMessage("Renderer failed to build spawn packets").create();
        }
        catch (Exception e) {
            throw ExecutionErrorException.forMethod("ServerBackend#disguise").causedBy(e).withMessage("Unknown error").create();
        }
    }

    private boolean unDisguise(Player player, boolean unregisterFromRenderer) {
        UUID uuid;
        ServerDisguiseWrapper wrapper;
        if (unregisterFromRenderer) {
            this.serverRenderer.unRegisterEntity(player);
        }
        if ((wrapper = (ServerDisguiseWrapper)this.disguiseWrapperMap.getOrDefault(uuid = player.getUniqueId(), null)) != null) {
            wrapper.dispose();
        }
        this.disguiseWrapperMap.remove(uuid);
        return true;
    }

    @Override
    public boolean unDisguise(Player player) {
        return this.unDisguise(player, true);
    }

    @Override
    @javax.annotation.Nullable
    public ServerDisguiseWrapper fromOfflineSave(String offlineParameter) {
        String[] sp = offlineParameter.split("\\|", 2);
        if (sp.length < 2) {
            this.logger.warn("Invalid offline parameter: '%s'".formatted(offlineParameter));
            return null;
        }
        if (!sp[0].equals(this.getIdentifier())) {
            this.logger.error("The given parameter is not compatible with current backend. (Expected '%s', Current '%s')".formatted(sp[0], this.getIdentifier()));
            return null;
        }
        String[] spilt = sp[1].split("@", 2);
        if (spilt.length < 2) {
            this.logger.warn("Invalid offline parameter: '%s'".formatted(sp[1]));
            return null;
        }
        String snbt = spilt[1];
        String typeId = spilt[0];
        EntityType typeMatch = Arrays.stream(EntityType.values()).filter(t -> t != EntityType.UNKNOWN && t.getKey().asString().equals(typeId)).findFirst().orElse(null);
        if (typeMatch == null) {
            this.logger.warn("Invalid EntityType: '%s'".formatted(typeId));
            return null;
        }
        ServerDisguise instance = new ServerDisguise(typeMatch);
        return new ServerDisguiseWrapper(instance, this);
    }

    @Override
    @javax.annotation.Nullable
    public String toOfflineSave(DisguiseWrapper<?> wrapper) {
        if (!(wrapper instanceof ServerDisguiseWrapper)) {
            return null;
        }
        ServerDisguiseWrapper serverWrapper = (ServerDisguiseWrapper)wrapper;
        String type = wrapper.getEntityType().getKey().asString();
        return "%s@%s".formatted(type, "NIL");
    }

    @Override
    public Collection<ServerDisguiseWrapper> listInstances() {
        return this.disguiseWrapperMap.values();
    }
}

