/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.backends.EventWrapper;
import xyz.nifeather.morph.backends.WrapperEvent;
import xyz.nifeather.morph.backends.WrapperProperties;
import xyz.nifeather.morph.backends.server.ServerBackend;
import xyz.nifeather.morph.backends.server.ServerDisguise;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.AgeableMobWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.backends.server.renderer.utilties.WatcherUtils;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.OffTreeProperties;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;

public class ServerDisguiseWrapper
extends EventWrapper<ServerDisguise> {
    private final ServerBackend backend;
    private static final Logger logger = FeatherMorphMain.getInstance().getSLF4JLogger();
    private final Map<SingleProperty<?>, Object> disguiseProperties = new ConcurrentHashMap();
    private boolean aggressive;
    private Player bindingPlayer;
    private SingleWatcher bindingWatcher;

    public ServerDisguiseWrapper(@NotNull ServerDisguise instance, ServerBackend backend) {
        super(instance, backend);
        this.backend = backend;
        this.writeProperty(OffTreeProperties.FAKE_EQUIPMENT, new DisguiseEquipment());
    }

    @Override
    public CompoundTag getCompound() {
        CompoundTag tagCopy = new CompoundTag();
        if (this.bindingWatcher != null) {
            tagCopy.merge(WatcherUtils.buildCompoundFromWatcher(this.bindingWatcher));
        }
        return tagCopy;
    }

    @Override
    @NotNull
    public UUID getVirtualEntityUUID() {
        UUID uuid = this.bindingWatcher == null ? null : this.bindingWatcher.readEntryOrThrow(CustomEntries.SPAWN_UUID);
        return Objects.requireNonNull(uuid, "VirtualEntityUUID is not set for an instance of ServerDisguiseWrapper");
    }

    @Override
    public EntityEquipment getFakeEquipments() {
        return this.readPropertyOrThrow(OffTreeProperties.FAKE_EQUIPMENT);
    }

    @Override
    public void setFakeEquipments(@NotNull EntityEquipment value) {
        DisguiseEquipment newEquipment = new DisguiseEquipment();
        newEquipment.setArmorContents(value.getArmorContents());
        newEquipment.setHandItems(value.getItemInMainHand(), value.getItemInOffHand());
        this.writeProperty(OffTreeProperties.FAKE_EQUIPMENT, newEquipment);
    }

    @Override
    public void setServerSelfView(boolean enabled) {
    }

    @Override
    public EntityType getEntityType() {
        return ((ServerDisguise)this.instance).type;
    }

    @Override
    public ServerDisguise copyInstance() {
        return ((ServerDisguise)this.instance).clone();
    }

    @Override
    public DisguiseWrapper<ServerDisguise> clone() {
        ServerDisguiseWrapper newInstance = ServerDisguiseWrapper.cloneFromExternal(this, (ServerBackend)this.getBackend());
        newInstance.disguiseProperties.putAll(this.disguiseProperties);
        newInstance.writeProperty(OffTreeProperties.FAKE_EQUIPMENT, this.readPropertyOrThrow(OffTreeProperties.FAKE_EQUIPMENT));
        return newInstance;
    }

    public static ServerDisguiseWrapper cloneFromExternal(DisguiseWrapper<?> other, ServerBackend backend) {
        ServerDisguiseWrapper newInstance = new ServerDisguiseWrapper(new ServerDisguise(other.getEntityType()), backend);
        newInstance.disguiseProperties.putAll(other.getProperties());
        return newInstance;
    }

    @Override
    public <X> void writeProperty(SingleProperty<X> property, X value) {
        this.disguiseProperties.put(property, value);
        if (!property.id().startsWith("wrapper_") && this.bindingWatcher != null) {
            this.bindingWatcher.writeProperty(property, value);
        }
    }

    @Override
    @NotNull
    public <X> X readProperty(SingleProperty<X> property) {
        return this.readPropertyOr(property, property.defaultVal());
    }

    @Override
    public <X> X readPropertyOr(SingleProperty<X> property, X defaultVal) {
        return (X)this.disguiseProperties.getOrDefault(property, defaultVal);
    }

    @Override
    public <X> X readPropertyOrThrow(SingleProperty<X> property) {
        X val = this.disguiseProperties.getOrDefault(property, null);
        if (val == null) {
            throw new NullDependencyException("The requested property '%s' was not found in %s".formatted(property.id(), this));
        }
        return val;
    }

    @Override
    public Map<SingleProperty<?>, Object> getProperties() {
        return new Object2ObjectOpenHashMap(this.disguiseProperties);
    }

    @Override
    public void setDisguiseName(String name) {
        super.setDisguiseName(name);
        if (this.bindingWatcher != null) {
            this.bindingWatcher.writeEntry(CustomEntries.DISGUISE_NAME, name);
        }
    }

    @Override
    public boolean isBaby() {
        if (!(this.bindingWatcher instanceof AgeableMobWatcher)) {
            return false;
        }
        return this.bindingWatcher.readOr(ValueIndex.AGEABLE_MOB.IS_BABY, false);
    }

    @Override
    public void applySkin(@NotNull GameProfile profile) {
        if (this.getEntityType() != EntityType.PLAYER) {
            return;
        }
        this.writeProperty(WrapperProperties.PROFILE, Optional.of(profile));
        if (this.bindingWatcher != null) {
            this.bindingWatcher.writeEntry(CustomEntries.PROFILE, profile);
        }
        this.callEvent(WrapperEvent.SKIN_SET, profile);
    }

    @Override
    public void postBuildDisguise(DisguiseState state, @Nullable Entity targetEntity) {
    }

    @Override
    public void update(DisguiseState state, Player player) {
    }

    @Override
    public void setAggressive(boolean aggressive) {
        super.setAggressive(aggressive);
        this.aggressive = aggressive;
        this.bindingWatcher.writeEntry(CustomEntries.IS_AGGRESSIVE, aggressive);
    }

    @Override
    public void playAttackAnimation() {
        super.playAttackAnimation();
        this.bindingWatcher.writeEntry(CustomEntries.ATTACK_ANIMATION, true);
    }

    public Player getBindingPlayer() {
        return this.bindingPlayer;
    }

    @Nullable
    public SingleWatcher getBindingWatcher() {
        return this.bindingWatcher;
    }

    public void setRenderParameters(@NotNull Player newBinding, @NotNull SingleWatcher bindingWatcher) {
        Objects.requireNonNull(bindingWatcher, "Null Watcher!");
        this.bindingPlayer = newBinding;
        if (this.bindingWatcher != null) {
            this.bindingWatcher.dispose();
            this.bindingWatcher = null;
        }
        this.refreshRegistry(newBinding, bindingWatcher);
        this.bindingWatcher = bindingWatcher;
    }

    private void refreshRegistry(@NotNull Player bindingPlayer, @NotNull SingleWatcher bindingWatcher) {
        this.disguiseProperties.forEach((property, value) -> bindingWatcher.writeProperty(property, value));
        if (this.getEntityType() == EntityType.PLAYER) {
            Optional<GameProfile> profileOptional = this.readProperty(WrapperProperties.PROFILE);
            profileOptional.ifPresent(p -> bindingWatcher.writeEntry(CustomEntries.PROFILE, p));
        }
        bindingWatcher.writeEntry(CustomEntries.DISPLAY_FAKE_EQUIPMENT, this.readProperty(OffTreeProperties.DISPLAY_FAKE_EQUIPMENT));
        bindingWatcher.writeEntry(CustomEntries.EQUIPMENT, this.readPropertyOrThrow(OffTreeProperties.FAKE_EQUIPMENT));
        if (bindingWatcher.getEntityType() == EntityType.GHAST) {
            bindingWatcher.writePersistent(ValueIndex.GHAST.CHARGING, this.aggressive);
        }
    }

    @Override
    public void playAnimation(String animationId) {
        if (this.bindingWatcher != null) {
            this.bindingWatcher.writeEntry(CustomEntries.ANIMATION, animationId);
        }
    }

    @Override
    public void onPlayerJoin(Player newInstance) {
        if (this.bindingWatcher == null) {
            return;
        }
        this.bindingWatcher.writeEntry(CustomEntries.SPAWN_ID, newInstance.getEntityId());
        this.bindingPlayer = newInstance;
        if (this.bindingWatcher.readEntryOrDefault(CustomEntries.WARDEN_VANISHED, false).booleanValue()) {
            this.bindingWatcher.writeEntry(CustomEntries.ANIMATION, "appear");
        }
    }
}

