/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.json.JSONComponentSerializer;
import net.kyori.adventure.util.TriState;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.util.Vector;
import xyz.nifeather.morph.backends.server.renderer.network.PacketFactory;
import xyz.nifeather.morph.backends.server.renderer.network.ProtocolEquipment;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.basetypes.EntityValues;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.BuildFailedException;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.FoliaThreadUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class EntityWatcher
extends SingleWatcher {
    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.BASE_ENTITY);
    }

    public EntityWatcher(Player bindingPlayer, EntityType entityType) {
        super(bindingPlayer, entityType);
    }

    protected byte getPlayerBitMask(Player player) {
        byte bitMask = 0;
        if (player.getFireTicks() > 0 || player.getVisualFire() == TriState.TRUE) {
            bitMask = (byte)(bitMask | 1);
        }
        if (player.isSneaking()) {
            bitMask = (byte)(bitMask | 2);
        }
        if (player.isSprinting()) {
            bitMask = (byte)(bitMask | 8);
        }
        if (player.isSwimming()) {
            bitMask = (byte)(bitMask | 0x10);
        }
        if (player.isInvisible()) {
            bitMask = (byte)(bitMask | 0x20);
        }
        if (player.isGlowing()) {
            bitMask = (byte)(bitMask | 0x40);
        }
        if (NmsRecord.ofPlayer(player).isFallFlying()) {
            bitMask = (byte)(bitMask | 0xFFFFFF80);
        }
        return bitMask;
    }

    protected WrapperPlayServerEntityEquipment getEquipmentPacket() {
        Player player = this.getBindingPlayer();
        Boolean shouldDisplayFakeEquip = this.readEntryOrDefault(CustomEntries.DISPLAY_FAKE_EQUIPMENT, false);
        EntityEquipment equipment = shouldDisplayFakeEquip != false ? (EntityEquipment)this.readEntryOrDefault(CustomEntries.EQUIPMENT, new DisguiseEquipment.EmptyDisguiseEquipment()) : player.getEquipment();
        WrapperPlayServerEntityEquipment packet = new WrapperPlayServerEntityEquipment(player.getEntityId(), ProtocolEquipment.toPEEquipmentList(equipment));
        PacketFactory.markEquipmentPacket(packet);
        return packet;
    }

    private List<PacketWrapper<?>> buildSpawnPacketsFor(Player player) {
        int[] passengers;
        ObjectArrayList packets = new ObjectArrayList();
        ServerPlayer nmsPlayer = NmsRecord.ofPlayer(player);
        UUID spawnUUID = this.readEntryOrThrow(CustomEntries.SPAWN_UUID);
        if (spawnUUID.equals(Uuids.NIL_UUID)) {
            throw new IllegalStateException("A watcher with NIL UUID?!");
        }
        WrapperPlayServerDestroyEntities packetDestroy = new WrapperPlayServerDestroyEntities(this.readEntryOrThrow(CustomEntries.SPAWN_ID).intValue());
        packets.add(packetDestroy);
        Float pitch = this.readEntryOrDefault(CustomEntries.OVERLAYED_PITCH, Float.valueOf(player.getPitch()));
        Float yaw = this.readEntryOrDefault(CustomEntries.OVERLAYED_YAW, Float.valueOf(player.getYaw()));
        EntityType disguiseEntityType = this.getEntityType();
        Vector playerMotion = player.getVelocity();
        WrapperPlayServerSpawnEntity spawnPacket = new WrapperPlayServerSpawnEntity(this.readEntryOrThrow(CustomEntries.SPAWN_ID).intValue(), spawnUUID, SpigotConversionUtil.fromBukkitEntityType((EntityType)disguiseEntityType), new Location(new Vector3d(player.getX(), player.getY(), player.getZ()), yaw.floatValue(), pitch.floatValue()), nmsPlayer.getYHeadRot(), 0, new Vector3d(playerMotion.getX(), playerMotion.getY(), playerMotion.getZ()));
        packets.add(spawnPacket);
        packets.add(this.getEquipmentPacket());
        packets.add(PacketFactory.buildFullMetaPacket(player, this));
        if (player.getVehicle() != null) {
            passengers = player.getVehicle().getPassengers().stream().mapToInt(Entity::getEntityId).toArray();
            packets.add(new WrapperPlayServerSetPassengers(player.getVehicle().getEntityId(), passengers));
        }
        if (!player.getPassengers().isEmpty()) {
            passengers = player.getPassengers().stream().mapToInt(Entity::getEntityId).toArray();
            packets.add(new WrapperPlayServerSetPassengers(player.getEntityId(), passengers));
        }
        return packets;
    }

    @Override
    public List<PacketWrapper<?>> buildSpawnPackets() throws BuildFailedException {
        ObjectArrayList result = new ObjectArrayList();
        if (this.readEntryOrDefault(CustomEntries.VANISHED, false).booleanValue()) {
            return result;
        }
        EntityType disguiseEntityType = this.getEntityType();
        net.minecraft.world.entity.EntityType<?> nmsSpawnType = EntityTypeUtils.getNmsType(disguiseEntityType);
        if (nmsSpawnType == null) {
            this.logger.error("No NMS Type for Bukkit Type '%s'".formatted(disguiseEntityType));
            this.logger.error("Not building spawn packets!");
            return result;
        }
        try {
            return FoliaThreadUtils.runOnEntitySync(this.getBindingPlayer(), this::buildSpawnPacketsFor, FoliaThreadUtils.DEFAULT_WAIT_TIMEOUT);
        }
        catch (TimeoutException e) {
            throw new BuildFailedException("Waiting too long for player '%s'!".formatted(this.getBindingPlayer().getName()));
        }
        catch (InterruptedException e) {
            throw new BuildFailedException("Task has been interrupted, why?", e);
        }
        catch (CancellationException e) {
            throw new BuildFailedException("Task cancelled, why?", e);
        }
        catch (Throwable t) {
            throw new BuildFailedException("Unhandled exception while building packet for '%s'!", t);
        }
    }

    @Override
    protected void doSync() {
        super.doSync();
        Player player = this.getBindingPlayer();
        EntityValues values = ValueIndex.BASE_ENTITY;
        this.writeTemp(values.GENERAL, this.getPlayerBitMask(player));
        this.writeTemp(values.NO_GRAVITY, !player.hasGravity());
        this.writeTemp(values.POSE, SpigotConversionUtil.fromBukkitPose((Pose)player.getPose()));
        this.writeTemp(values.FROZEN_TICKS, player.getFreezeTicks());
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.DISGUISE_NAME) && this.getEntityType() != EntityType.PLAYER) {
            String str = newVal.toString();
            TextComponent component = str.isEmpty() ? null : Component.text((String)str);
            this.writePersistent(ValueIndex.BASE_ENTITY.CUSTOM_NAME, component == null ? Optional.empty() : Optional.of(component));
        }
        if (entry.equals(CustomEntries.VANISHED)) {
            WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(this.readEntryOrThrow(CustomEntries.SPAWN_ID).intValue());
            this.sendPacketToAffectedPlayers((PacketWrapper<?>)packet);
        }
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        Optional<Component> customName = this.read(ValueIndex.BASE_ENTITY.CUSTOM_NAME);
        customName.ifPresent(c -> nbt.putString("CustomName", (String)JSONComponentSerializer.json().serialize(c)));
        nbt.putBoolean("CustomNameVisible", this.read(ValueIndex.BASE_ENTITY.CUSTOM_NAME_VISIBLE).booleanValue());
    }
}

