/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.slimemagma;

import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.SlimeMagmaProperties;

public class AbstractSlimeWatcher
extends LivingEntityWatcher {
    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.SLIME_MAGMA);
    }

    public AbstractSlimeWatcher(Player bindingPlayer, EntityType entityType) {
        super(bindingPlayer, entityType);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        SlimeMagmaProperties properties = DisguiseProperties.INSTANCE.getOrThrow(SlimeMagmaProperties.class);
        if (property.equals(properties.SIZE)) {
            int size = (Integer)value;
            this.writeEntry(CustomEntries.SLIME_SIZE_REAL, size);
            this.writePersistent(ValueIndex.SLIME_MAGMA.SIZE, size);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        nbt.putInt("Size", this.readEntryOrDefault(CustomEntries.SLIME_SIZE_REAL, 1).intValue());
    }
}

