/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.AbstractValues;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.values.SingleValue;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class MetaPacketListener
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    @Override
    public String getIdentifier() {
        return "meta_listener";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.ENTITY_METADATA) {
            return;
        }
        WrapperPlayServerEntityMetadata wrapper = new WrapperPlayServerEntityMetadata(event);
        this.onMetaPacket(wrapper, event);
    }

    private void onMetaPacket(WrapperPlayServerEntityMetadata packet, PacketSendEvent packetEvent) {
        Player sourcePlayer = this.getPlayerFrom(packet.getEntityId());
        if (sourcePlayer == null) {
            return;
        }
        if (sourcePlayer.equals(packetEvent.getPlayer())) {
            return;
        }
        SingleWatcher watcher = this.registry.getWatcher(sourcePlayer.getUniqueId());
        if (watcher == null) {
            return;
        }
        Object targetPlayer = packetEvent.getPlayer();
        if (targetPlayer.equals(sourcePlayer)) {
            return;
        }
        WrapperPlayServerEntityMetadata wrapper = new WrapperPlayServerEntityMetadata(packetEvent);
        boolean isPlayerDisguise = watcher.getEntityType() == EntityType.PLAYER;
        this.rebuildServerMetaPacket(isPlayerDisguise ? ValueIndex.PLAYER : ValueIndex.BASE_LIVING, watcher, wrapper);
    }

    public void rebuildServerMetaPacket(AbstractValues av, SingleWatcher watcher, WrapperPlayServerEntityMetadata packetWrapper) {
        List<SingleValue<?>> values = av.getValues();
        List originalData = packetWrapper.getEntityMetadata();
        if (originalData.removeIf(wrapped -> wrapped.getValue().equals("~FEATHERMORPH GENERATED METADATA, THIS MESSAGE SHOULD BE REMOVED, OR SOMETHING MAY GONE WRONG!"))) {
            packetWrapper.setEntityMetadata(originalData);
            return;
        }
        ObjectArrayList valuesToOverwrite = new ObjectArrayList();
        List<Integer> blockedValues = watcher.getBlockedValues();
        for (EntityData raw : originalData) {
            SingleValue singleValue;
            int index = raw.getIndex();
            if (blockedValues.contains(index) || (singleValue = (SingleValue)values.stream().filter(sv -> sv.index() == index && raw.getType().equals(sv.type())).findFirst().orElse(null)) == null) continue;
            Object val = watcher.readOr(singleValue, null);
            if (val != null) {
                EntityData wrapped2 = new EntityData(singleValue.index(), singleValue.type(), val);
                valuesToOverwrite.add(wrapped2);
                continue;
            }
            valuesToOverwrite.add(raw);
        }
        packetWrapper.setEntityMetadata((List)valuesToOverwrite);
    }
}

