/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.registries;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.AllayWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ArmadilloWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ArmorStandWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.AxolotlWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.CatWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ChickenWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.CowWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.CreakingWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.CreeperWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.DonkeyWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.EHasAttackAnimationWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.EnderDragonWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.EvokerWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.FoxWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.FrogWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.GhastWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.GoatWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.GuardianWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.HappyGhastWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.HoglinWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.MooshroomWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PandaWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ParrotWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PhantomWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PigWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PiglinWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PlayerWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.PufferfishWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.RabbitWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.SheepWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ShulkerWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.SnifferWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.SnowGolemWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.TropicalFishWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.VillagerWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.WardenWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.WolfWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ZoglinWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ZombieVillagerWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ZombieWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.horses.AbstractHorseWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.horses.HorseWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.horses.SkeletonHorseWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.horses.ZombieHorseWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.llama.LlamaWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.llama.TraderLlamaWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.slimemagma.MagmaWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.slimemagma.SlimeWatcher;

public class WatcherIndex {
    private final Map<EntityType, Function<Player, SingleWatcher>> typeWatcherMap = new Object2ObjectOpenHashMap();

    public static WatcherIndex getInstance() {
        return WatcherInstanceLazyHolder.instance;
    }

    public WatcherIndex() {
        this.setTypeWatcher(EntityType.PLAYER, PlayerWatcher::new);
        this.setTypeWatcher(EntityType.ALLAY, AllayWatcher::new);
        this.setTypeWatcher(EntityType.ARMOR_STAND, ArmorStandWatcher::new);
        this.setTypeWatcher(EntityType.SLIME, SlimeWatcher::new);
        this.setTypeWatcher(EntityType.MAGMA_CUBE, MagmaWatcher::new);
        this.setTypeWatcher(EntityType.GHAST, GhastWatcher::new);
        this.setTypeWatcher(EntityType.HORSE, HorseWatcher::new);
        this.setTypeWatcher(EntityType.SKELETON_HORSE, SkeletonHorseWatcher::new);
        this.setTypeWatcher(EntityType.ZOMBIE_HORSE, ZombieHorseWatcher::new);
        this.setTypeWatcher(EntityType.DONKEY, DonkeyWatcher::new);
        this.setTypeWatcher(EntityType.CAMEL, p -> new AbstractHorseWatcher((Player)p, EntityType.CAMEL));
        this.setTypeWatcher(EntityType.LLAMA, LlamaWatcher::new);
        this.setTypeWatcher(EntityType.TRADER_LLAMA, TraderLlamaWatcher::new);
        this.setTypeWatcher(EntityType.FOX, FoxWatcher::new);
        this.setTypeWatcher(EntityType.PARROT, ParrotWatcher::new);
        this.setTypeWatcher(EntityType.CAT, CatWatcher::new);
        this.setTypeWatcher(EntityType.GOAT, GoatWatcher::new);
        this.setTypeWatcher(EntityType.RABBIT, RabbitWatcher::new);
        this.setTypeWatcher(EntityType.TROPICAL_FISH, TropicalFishWatcher::new);
        this.setTypeWatcher(EntityType.FROG, FrogWatcher::new);
        this.setTypeWatcher(EntityType.PANDA, PandaWatcher::new);
        this.setTypeWatcher(EntityType.VILLAGER, VillagerWatcher::new);
        this.setTypeWatcher(EntityType.SNOW_GOLEM, SnowGolemWatcher::new);
        this.setTypeWatcher(EntityType.CREEPER, CreeperWatcher::new);
        this.setTypeWatcher(EntityType.PIGLIN, PiglinWatcher::new);
        this.setTypeWatcher(EntityType.ZOMBIE, ZombieWatcher::new);
        this.setTypeWatcher(EntityType.ZOMBIE_VILLAGER, ZombieVillagerWatcher::new);
        this.setTypeWatcher(EntityType.ZOGLIN, ZoglinWatcher::new);
        this.setTypeWatcher(EntityType.HOGLIN, HoglinWatcher::new);
        this.setTypeWatcher(EntityType.GUARDIAN, GuardianWatcher::new);
        this.setTypeWatcher(EntityType.AXOLOTL, AxolotlWatcher::new);
        this.setTypeWatcher(EntityType.MOOSHROOM, MooshroomWatcher::new);
        this.setTypeWatcher(EntityType.SHEEP, SheepWatcher::new);
        this.setTypeWatcher(EntityType.WOLF, WolfWatcher::new);
        this.setTypeWatcher(EntityType.PHANTOM, PhantomWatcher::new);
        this.setTypeWatcher(EntityType.WARDEN, WardenWatcher::new);
        this.setTypeWatcher(EntityType.IRON_GOLEM, p -> new EHasAttackAnimationWatcher((Player)p, EntityType.IRON_GOLEM));
        this.setTypeWatcher(EntityType.RAVAGER, p -> new EHasAttackAnimationWatcher((Player)p, EntityType.RAVAGER));
        this.setTypeWatcher(EntityType.SNIFFER, SnifferWatcher::new);
        this.setTypeWatcher(EntityType.ARMADILLO, ArmadilloWatcher::new);
        this.setTypeWatcher(EntityType.SHULKER, ShulkerWatcher::new);
        this.setTypeWatcher(EntityType.PUFFERFISH, PufferfishWatcher::new);
        this.setTypeWatcher(EntityType.CREAKING, CreakingWatcher::new);
        this.setTypeWatcher(EntityType.PIG, PigWatcher::new);
        this.setTypeWatcher(EntityType.COW, CowWatcher::new);
        this.setTypeWatcher(EntityType.CHICKEN, ChickenWatcher::new);
        this.setTypeWatcher(EntityType.ENDER_DRAGON, EnderDragonWatcher::new);
        this.setTypeWatcher(EntityType.EVOKER, EvokerWatcher::new);
        this.setTypeWatcher(EntityType.HAPPY_GHAST, HappyGhastWatcher::new);
    }

    private void setTypeWatcher(EntityType type, Function<Player, SingleWatcher> func) {
        this.typeWatcherMap.put(type, func);
    }

    public SingleWatcher getWatcherForType(Player bindingPlayer, EntityType entityType) {
        Function watcherFunc = this.typeWatcherMap.getOrDefault(entityType, null);
        if (watcherFunc == null) {
            return new LivingEntityWatcher(bindingPlayer, entityType);
        }
        return (SingleWatcher)watcherFunc.apply(bindingPlayer);
    }

    private static class WatcherInstanceLazyHolder {
        public static final WatcherIndex instance = new WatcherIndex();

        private WatcherInstanceLazyHolder() {
        }
    }
}

