/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.brigadier.arguments.DisguiseIdentifierArgumentType;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.CommonStrings;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class DiscardMorphCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager morphManager;

    @Override
    @NotNull
    public String name() {
        return "discard-morph";
    }

    @Override
    public boolean register(Commands dispatcher) {
        dispatcher.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(Commands.argument((String)"discard-target", (ArgumentType)DisguiseIdentifierArgumentType.FOR_PLAYER).executes(this::execUserDiscard))).build());
        return IConvertibleBrigadier.super.register(dispatcher);
    }

    private int execUserDiscard(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(entity instanceof Player)) {
            Component msg = MessageUtils.prefixes(sender, CommonStrings.playerNotDefinedString());
            sender.sendMessage(msg);
            return 0;
        }
        Player player = (Player)entity;
        String targetID = DisguiseIdentifierArgumentType.getArgument(context, "discard-target");
        FormattableMessage formattable = this.morphManager.revokeMorphFromPlayer(player, targetID) ? CommandStrings.revokeSuccessString() : CommandStrings.revokeFailString();
        Component msg = MessageUtils.prefixes(sender, formattable.resolve("what", targetID).resolve("who", player.getName()));
        sender.sendMessage(msg);
        return 1;
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.discardMorphCommandDescription();
    }
}

