/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.command.CommandSender;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.IHaveFormattableHelp;
import xyz.nifeather.morph.commands.MorphCommandManager;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.subcommands.plugin.helpsections.Entry;
import xyz.nifeather.morph.commands.subcommands.plugin.helpsections.Section;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class HelpSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphCommandManager cmdHelper;
    private final List<Section> commandSections = new CopyOnWriteArrayList<Section>();

    @Override
    public String name() {
        return "help";
    }

    @Initializer
    private void load() {
        this.setupCommandSections();
    }

    private void setupCommandSections() {
        Section miscCommandSection = new Section("/", HelpStrings.morphCommandDescription(), (List<FormattableMessage>)ObjectList.of((Object)HelpStrings.morphCommandSpecialNote1(), (Object)HelpStrings.morphCommandSpecialNote2()));
        this.commandSections.add(miscCommandSection);
        for (IConvertibleBrigadier c : this.cmdHelper.commands()) {
            if (!c.children().isEmpty()) {
                String parentCommandName = c.name();
                ObjectArrayList notes = new ObjectArrayList(c.getNotes());
                Section section = new Section(parentCommandName, c.getHelpMessage(), (List<FormattableMessage>)notes);
                for (IHaveFormattableHelp iHaveFormattableHelp : c.children()) {
                    String cmdName = parentCommandName + " " + iHaveFormattableHelp.name();
                    section.add(new Entry(iHaveFormattableHelp.permission(), cmdName, iHaveFormattableHelp.getHelpMessage(), "/" + cmdName));
                }
                this.commandSections.add(section);
                continue;
            }
            miscCommandSection.add(new Entry(c.permission(), c.name(), c.getHelpMessage(), "/" + c.name()));
        }
    }

    private List<Component> constructSectionMessage(CommandSender sender, Section section) {
        List<Entry> entries = section.getEntries();
        String locale = MessageUtils.getLocale(sender);
        ObjectArrayList list = ObjectArrayList.of((Object[])new Component[]{Component.empty(), HelpStrings.commandSectionHeaderString().resolve("basename", section.getCommandBaseName()).toComponent(locale)});
        for (Entry entry : entries) {
            String perm = entry.permission();
            if (perm != null && !sender.hasPermission(perm)) continue;
            Component msg = HelpStrings.commandEntryString().withLocale(locale).resolve("basename", entry.baseName()).resolve("description", entry.description(), null).toComponent(null).decorate(TextDecoration.UNDERLINED).hoverEvent((HoverEventSource)HoverEvent.showText((Component)HelpStrings.clickToCompleteString().toComponent(locale))).clickEvent(ClickEvent.suggestCommand((String)entry.suggestingCommand()));
            list.add((Object)msg);
        }
        if (section.getNotes() != null && !section.getNotes().isEmpty()) {
            list.addAll(ObjectList.of((Object)Component.empty(), (Object)HelpStrings.specialNoteString().toComponent(locale)));
            for (FormattableMessage f : section.getNotes()) {
                list.add((Object)f.toComponent(locale).decorate(TextDecoration.ITALIC));
            }
        }
        list.add((Object)Component.empty());
        return list;
    }

    private List<Component> constructHelpMessage(CommandSender sender) {
        ObjectArrayList list = new ObjectArrayList();
        String locale = MessageUtils.getLocale(sender);
        list.add((Object)HelpStrings.avaliableCommandHeaderString().toComponent(locale));
        for (Section section : this.commandSections) {
            Component msg = HelpStrings.commandNamePatternString().withLocale(locale).resolve("basename", section.getCommandBaseName()).resolve("description", section.getDescription(), null).toComponent(locale).decorate(TextDecoration.UNDERLINED).clickEvent(ClickEvent.runCommand((String)("/feathermorph " + this.name() + " " + section.getCommandBaseName()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)HelpStrings.clickToViewString().toComponent(locale)));
            list.add((Object)msg);
        }
        return list;
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).executes(this::executeNoArgs)).then(Commands.argument((String)"section", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggestSection).executes(this::executeWithArgs)));
    }

    private int executeNoArgs(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        for (Component s : this.constructHelpMessage(sender)) {
            sender.sendMessage(MessageUtils.prefixes(sender, s));
        }
        return 1;
    }

    private int executeWithArgs(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String sectionName = StringArgumentType.getString(context, (String)"section");
        Section section = this.commandSections.stream().filter(s -> s.getCommandBaseName().equalsIgnoreCase(sectionName)).findFirst().orElse(null);
        if (section != null) {
            for (Component s2 : this.constructSectionMessage(sender, section)) {
                sender.sendMessage(MessageUtils.prefixes(sender, s2));
            }
        } else {
            sender.sendMessage(MessageUtils.prefixes(sender, HelpStrings.sectionNotFoundString().withLocale(MessageUtils.getLocale(sender))));
        }
        return 1;
    }

    private CompletableFuture<Suggestions> suggestSection(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        String baseName = suggestionsBuilder.getRemainingLowerCase();
        List<Section> matchedSections = this.commandSections.stream().filter(s -> s.getCommandBaseName().toLowerCase().startsWith(baseName.toLowerCase())).toList();
        for (Section s2 : matchedSections) {
            suggestionsBuilder.suggest(s2.getCommandBaseName());
        }
        return suggestionsBuilder.buildFuture();
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.helpDescription();
    }
}

