/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.permissions;

import xyz.nifeather.morph.misc.DisguiseTypes;

public class CommonPermissions {
    private static final String PERM_ROOT = "feathermorph.";
    public static final String SEND_REQUEST = "feathermorph.request.send";
    public static final String ACCEPT_REQUEST = "feathermorph.request.accept";
    public static final String DENY_REQUEST = "feathermorph.request.deny";
    public static final String ACQUIRE_MORPH = "feathermorph.acquire_morph";
    public static final String MORPH = "feathermorph.morph";
    public static final String UNMORPH = "feathermorph.unmorph";
    public static final String SKILL = "feathermorph.skill";
    public static final String HEAD_MORPH = "feathermorph.headmorph";
    public static final String CHAT_OVERRIDE = "feathermorph.chatoverride";
    public static final String CHAT_OVERRIDE_REVEAL = "feathermorph.chatoverride.reveal";
    public static final String MIRROR = "feathermorph.mirror";
    public static final String MIRROR_IMMUNE = "feathermorph.mirror.immune";
    public static final String DISGUISE_REVEALING = "feathermorph.disguise_revealing";
    public static final String CHECK_UPDATE = "feathermorph.check_update";
    public static final String LOOKUP = "feathermorph.lookup";
    public static final String ACCESS_SKIN_CACHE = "feathermorph.skin_cache";
    public static final String MAKE_DISGUISE_TOOL = "feathermorph.make_disguise_tool";
    public static final String SET_BACKEND = "feathermorph.switch_backend";
    public static final String SET_OPTIONS = "feathermorph.toggle";
    public static final String QUERY_STATES = "feathermorph.query";
    public static final String CHECK_STAT = "feathermorph.stat";
    public static final String DO_RELOAD = "feathermorph.reload";
    public static final String MANAGE_DISGUISES = "feathermorph.manage";
    public static final String MANAGE_GRANT_DISGUISE = "feathermorph.manage.grant";
    public static final String MANAGE_REVOKE_DISGUISE = "feathermorph.manage.revoke";
    public static final String MANAGE_UNMORPH_DISGUISE = "feathermorph.manage.unmorph";
    public static final String MANAGE_MORPH_DISGUISE = "feathermorph.manage.morph";
    public static final String CAN_FLY = "feathermorph.can_fly";
    public static final String ALWAYS_CAN_FLY = "feathermorph.can_fly.always";
    public static final String TOGGLE_TOWN_FLIGHT = "feathermorph.toggle_town_fly";
    public static final String ADMIN = "feathermorph.admin";
    public static final String MAGIC_BOTTLE_USE = "feathermorph.magic_bottle.use";
    public static final String MAGIC_BOTTLE_EXCLUDE = "feathermorph.magic_bottle.exclude";
    public static final String DISGUISE_USE_REAL_UUID = "feathermorph.disguise_use_real_uuid";

    public static String skillPermissionOf(String skillIdentifier, String disguiseIdentifier) {
        if (disguiseIdentifier.startsWith(DisguiseTypes.PLAYER.getNameSpace())) {
            disguiseIdentifier = "player:all";
        }
        return "feathermorph.skill." + disguiseIdentifier.replace(":", ".") + "." + skillIdentifier.replace(":", ".");
    }

    public static String abilityPermissionOf(String abilityIdentifier, String disguiseIdentifier) {
        if (disguiseIdentifier.startsWith(DisguiseTypes.PLAYER.getNameSpace())) {
            disguiseIdentifier = "player:all";
        }
        return "feathermorph.ability." + disguiseIdentifier.replace(":", ".") + "." + abilityIdentifier.replace(":", ".");
    }

    public static String animationPermissionOf(String animationId, String disguiseID) {
        if (disguiseID.startsWith(DisguiseTypes.PLAYER.getNameSpace())) {
            disguiseID = "player:all";
        }
        return "feathermorph.emote." + disguiseID.replace(":", ".") + "." + animationId.replace(":", ".");
    }

    public static String CanFlyIn(String worldName) {
        return "feathermorph.can_fly.in." + worldName;
    }
}

