/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.protocol.s2c;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import xyz.nifeather.morph.network.multiInstance.protocol.IMasterHandler;
import xyz.nifeather.morph.network.multiInstance.protocol.SocketPlayerMeta;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class MIS2CSyncMetaCommand
extends MIS2CCommand {
    private final MetaSyncDataRoot data = new MetaSyncDataRoot();

    public List<SocketPlayerMeta> data() {
        return this.data.content;
    }

    public void appendMeta(SocketPlayerMeta meta) {
        this.data.content.add(meta);
    }

    public MIS2CSyncMetaCommand() {
        super("sync_player_meta");
    }

    public MIS2CSyncMetaCommand(MetaSyncDataRoot otherData) {
        this();
        this.data.content.addAll(otherData.content);
    }

    public MIS2CSyncMetaCommand(List<SocketPlayerMeta> metaList) {
        this();
        this.data.content.addAll(metaList);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        String str = MIS2CSyncMetaCommand.gson().toJson((Object)this.data);
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        map.put("meta_list", str);
        return map;
    }

    public static MIS2CSyncMetaCommand fromArguments(Map<String, String> arguments) {
        String metaList = Asserts.getStringOrThrow(arguments, "meta_list");
        MetaSyncDataRoot result = (MetaSyncDataRoot)MIS2CSyncMetaCommand.gson().fromJson(metaList, MetaSyncDataRoot.class);
        return new MIS2CSyncMetaCommand(result);
    }

    @Override
    public void onCommand(IMasterHandler handler) {
        handler.onSyncMeta(this);
    }

    public static class MetaSyncDataRoot {
        @Expose
        @SerializedName(value="content")
        public List<SocketPlayerMeta> content = new CopyOnWriteArrayList<SocketPlayerMeta>();
    }
}

