/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.providers.animation;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.providers.animation.SingleAnimation;

public abstract class AnimationSet {
    public static final SingleAnimation RESET = new SingleAnimation("reset", 1, true);
    public static final SingleAnimation TRY_RESET = new SingleAnimation("try_reset", 1, true);
    public static final SingleAnimation EXEC_DISABLE_SKILL = new SingleAnimation("exec_disable_skill", 0, false);
    public static final SingleAnimation EXEC_ENABLE_SKILL = new SingleAnimation("exec_enable_skill", 0, false);
    public static final SingleAnimation EXEC_DISABLE_AMBIENT = new SingleAnimation("exec_disable_ambient", 0, false);
    public static final SingleAnimation EXEC_ENABLE_AMBIENT = new SingleAnimation("exec_enable_ambient", 0, false);
    public static final SingleAnimation EXEC_DISABLE_BOSSBAR = new SingleAnimation("exec_disable_bossbar", 0, false);
    public static final SingleAnimation EXEC_ENABLE_BOSSBAR = new SingleAnimation("exec_enable_bossbar", 0, false);
    private final Map<String, Pair<List<SingleAnimation>, Boolean>> animationMap = new ConcurrentHashMap<String, Pair<List<SingleAnimation>, Boolean>>();
    private final List<String> registeredAnimations = new CopyOnWriteArrayList<String>();

    protected void registerCommon(String sequenceID, List<SingleAnimation> sequence) {
        this.register(sequenceID, sequence, false);
    }

    protected void registerPersistent(String sequenceID, List<SingleAnimation> sequence) {
        this.register(sequenceID, sequence, true);
    }

    protected void register(String sequenceID, List<SingleAnimation> sequence, boolean isPersistent) {
        this.animationMap.put(sequenceID, (Pair<List<SingleAnimation>, Boolean>)Pair.of(sequence, (Object)isPersistent));
        this.registeredAnimations.add(sequenceID);
    }

    @NotNull
    public Pair<List<SingleAnimation>, Boolean> sequenceOf(@NotNull String animationId) {
        return this.animationMap.getOrDefault(animationId, (Pair<List<SingleAnimation>, Boolean>)Pair.of(List.of(), (Object)false));
    }

    public List<String> getAvailableAnimationsForClient() {
        return new ObjectArrayList(this.registeredAnimations);
    }
}

