/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Messages;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public class FormattableMessage
implements Comparable<FormattableMessage> {
    private final String key;
    private final String defaultString;
    private final DependencyManager depManager;
    private final List<TagResolver> resolvers = new ObjectArrayList();
    private String locale = null;
    private MessageStore<?> cachedStore;
    private static final PlainTextComponentSerializer plainTextComponentSerializer = PlainTextComponentSerializer.plainText();

    public FormattableMessage(@NotNull String pluginNameSpace, @NotNull String key, @NotNull String defaultString) {
        this.defaultString = defaultString;
        this.key = key;
        this.depManager = DependencyManager.getInstance(pluginNameSpace);
    }

    public FormattableMessage(@NotNull XiaMoJavaPlugin owningPlugin, @NotNull String key, @NotNull String defaultString) {
        this(owningPlugin.getNamespace(), key, defaultString);
    }

    public FormattableMessage(@NotNull XiaMoJavaPlugin owningPlugin, String value) {
        this(owningPlugin.getNamespace(), "_", value);
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultString() {
        return this.defaultString;
    }

    public FormattableMessage resolve(String target, String value) {
        this.resolvers.add((TagResolver)Placeholder.parsed((String)target, (String)value));
        return this;
    }

    public FormattableMessage resolve(String target, Component value) {
        this.resolvers.add((TagResolver)Placeholder.component((String)target, (ComponentLike)value));
        return this;
    }

    public FormattableMessage resolve(String target, Object obj) {
        String str = "Nil";
        if (obj != null) {
            str = obj.toString();
        }
        this.resolve(target, str);
        return this;
    }

    public FormattableMessage resolve(String target, FormattableMessage formattable, String locale) {
        if (locale == null) {
            locale = this.locale;
        }
        this.resolvers.add((TagResolver)Placeholder.component((String)target, (ComponentLike)formattable.toComponent(locale)));
        return this;
    }

    public FormattableMessage resolve(String target, FormattableMessage formattableMessage) {
        return this.resolve(target, formattableMessage, this.locale);
    }

    @Nullable
    public String getLocale() {
        return this.locale;
    }

    public FormattableMessage withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    private MessageStore<?> getCachedStore() {
        if (this.cachedStore == null) {
            this.cachedStore = this.depManager.get(MessageStore.class);
        }
        return this.cachedStore;
    }

    public Component toComponent(@Nullable String locale, MessageStore<?> store) {
        if (store == null) {
            return Component.text((String)this.defaultString);
        }
        if (locale == null) {
            locale = this.locale;
        }
        String msg = this.key.equals("_") ? this.defaultString : store.get(this.key, this.defaultString, locale);
        return MiniMessage.miniMessage().deserialize(msg, TagResolver.resolver(this.resolvers));
    }

    public Component toComponent(@Nullable String locale, Class<? extends MessageStore<?>> depClass) {
        return this.toComponent(locale, this.depManager.get(depClass));
    }

    public Component toComponent(@Nullable String locale) {
        return this.toComponent(locale, this.getCachedStore());
    }

    public Component toComponent() {
        return this.toComponent(null, this.getCachedStore());
    }

    public String toString() {
        return plainTextComponentSerializer.serialize(this.toComponent());
    }

    public String toString(@Nullable String locale) {
        return plainTextComponentSerializer.serialize(this.toComponent(locale));
    }

    public String toString(@Nullable String locale, Class<? extends MessageStore<?>> depClass) {
        return plainTextComponentSerializer.serialize(this.toComponent(locale, depClass));
    }

    public String toString(@Nullable String locale, MessageStore<?> store) {
        return plainTextComponentSerializer.serialize(this.toComponent(locale, store));
    }

    @Override
    public int compareTo(@NotNull FormattableMessage formattableMessage) {
        return this.key.compareTo(formattableMessage.key);
    }
}

