/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrowableProjectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.SkillStrings;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public abstract class MorphSkill<T extends ISkillAbilityOption>
extends MorphPluginObject
implements ISkill<T> {
    protected void playSoundToNearbyPlayers(Player player, int distance, Key key, Sound.Source source) {
        Location loc = player.getLocation();
        Sound sound = Sound.sound((Key)key, (Sound.Source)source, (float)((float)distance / 8.0f), (float)1.0f);
        player.getWorld().playSound(sound, loc.getX(), loc.getY(), loc.getZ());
    }

    protected List<Player> findNearbyPlayers(Player player, int distance) {
        return DisguiseUtils.findNearbyPlayers(player, distance, false);
    }

    protected void sendDenyMessageToPlayer(Player player, Component text) {
        player.sendMessage(MessageUtils.prefixes((CommandSender)player, text.color((TextColor)NamedTextColor.RED)));
        player.playSound(Sound.sound((Key)Key.key((String)"minecraft", (String)"entity.villager.no"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f));
    }

    protected void notifyError(Player player) {
        this.sendDenyMessageToPlayer(player, SkillStrings.exceptionOccurredString().withLocale(MessageUtils.getLocale(player)).toComponent(null));
    }

    @Nullable
    protected <E extends Entity> E launchProjectile(Player player, EntityType fireballType, float multiplier) {
        Entity fireBall;
        try {
            fireBall = player.getWorld().spawnEntity(player.getEyeLocation(), fireballType, CreatureSpawnEvent.SpawnReason.CUSTOM);
        }
        catch (Throwable t) {
            this.logger.error("Unable to summon %s".formatted(fireballType), t);
            this.notifyError(player);
            return null;
        }
        if (fireBall instanceof Projectile) {
            Projectile projectile = (Projectile)fireBall;
            projectile.setShooter((ProjectileSource)player);
        }
        Entity entity = fireBall;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        double extraMultiplier = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ThrownPotion.class, ThrowableProjectile.class, LlamaSpit.class}, (Object)entity2, n)) {
            case 0 -> {
                ThrownPotion thrownPotion = (ThrownPotion)entity2;
                yield 2.25;
            }
            case 1 -> {
                ThrowableProjectile throwableProjectile = (ThrowableProjectile)entity2;
                yield 1.4;
            }
            case 2 -> {
                LlamaSpit llamaSpit = (LlamaSpit)entity2;
                yield 1.4;
            }
            default -> 1.0;
        };
        Vector velocity = player.getEyeLocation().getDirection().normalize().multiply(extraMultiplier);
        fireBall.setVelocity(velocity.multiply(multiplier));
        return (E)fireBall;
    }
}

