/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vex;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.api.morphs.skills.SkillNames;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.SkillStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.misc.mobs.MorphBukkitVexHolder;
import xyz.nifeather.morph.shaded.pluginbase.Exceptions.NullDependencyException;
import xyz.nifeather.morph.skills.impl.DelayedMorphSkill;
import xyz.nifeather.morph.skills.options.NoOpConfiguration;

public class EvokerMorphSkill
extends DelayedMorphSkill<NoOpConfiguration> {
    public static final String SESSION_DATA_SUMMON_VEX = "EVOKER_SKILL_SUMMON_VEX";
    public static final String SESSION_DATA_VEX_LIST = "EVOKER_SKILL_VEX_LIST";

    @Override
    public ISkillAbilityOptionHandler<NoOpConfiguration> optionHandler() {
        return NoOpConfiguration.OPTION_HANDLER;
    }

    @Override
    public void onDeEquip(DisguiseState state) {
        super.onDeEquip(state);
        VexHolderCounter counter = state.getSessionData(SESSION_DATA_VEX_LIST, VexHolderCounter.class);
        if (counter != null) {
            counter.killAll();
        }
        state.removeSessionData(SESSION_DATA_VEX_LIST);
    }

    @Override
    public void onInitialEquip(DisguiseState state) {
        super.onInitialEquip(state);
        state.setSessionData(SESSION_DATA_VEX_LIST, new VexHolderCounter());
    }

    private VexHolderCounter getVexCounter(DisguiseState state) {
        VexHolderCounter counter = state.getSessionData(SESSION_DATA_VEX_LIST, VexHolderCounter.class);
        if (counter == null) {
            throw new NullDependencyException("VexHolderCounter for %s's DisguiseState is NULL!".formatted(state.getPlayer().getName()));
        }
        return counter;
    }

    @Override
    protected DelayedMorphSkill.ExecuteResult preExecute(Player player, DisguiseState state, @NotNull NoOpConfiguration option) throws ExecutionErrorException {
        boolean summonVex = player.isSneaking();
        if (summonVex && player.getWorld().getDifficulty() == Difficulty.PEACEFUL) {
            this.sendDenyMessageToPlayer(player, SkillStrings.difficultyIsPeacefulString().withLocale(MessageUtils.getLocale(player)).toComponent(null));
            return DelayedMorphSkill.ExecuteResult.fail(10);
        }
        Key soundKey = summonVex ? Key.key((String)"entity.evoker.prepare_summon") : Key.key((String)"entity.evoker.prepare_attack");
        this.playSoundToNearbyPlayers(player, 16, soundKey, Sound.Source.HOSTILE);
        state.setSessionData(SESSION_DATA_SUMMON_VEX, new EvokerSkillDataRecord(summonVex, player.getTargetEntity(16)));
        state.getDisguiseWrapper().setAggressive(true);
        return DelayedMorphSkill.ExecuteResult.success(0);
    }

    @Override
    protected int getExecuteDelay(NoOpConfiguration option) {
        return 20;
    }

    private void doSummonVex(Player player, Entity targetEntity, DisguiseState state) {
        World world = player.getWorld();
        if (world.getDifficulty() == Difficulty.PEACEFUL) {
            return;
        }
        boolean isLiving = targetEntity instanceof LivingEntity;
        Location location = player.getEyeLocation();
        int maximumVexAmount = 6;
        VexHolderCounter vexCounter = this.getVexCounter(state);
        int targetAmount = 3;
        if (vexCounter.countAlive() + targetAmount > maximumVexAmount) {
            vexCounter.kill(3);
        }
        this.scheduleAt(player.getLocation(), () -> {
            for (int i = 0; i < targetAmount; ++i) {
                Vex vex = (Vex)world.spawn(location, Vex.class, CreatureSpawnEvent.SpawnReason.CUSTOM);
                vexCounter.addHolder(new MorphBukkitVexHolder(vex, player));
                vex.setLimitedLifetimeTicks(20 * (30 + NmsRecord.ofPlayer((Player)player).random.nextInt(90)));
                if (isLiving) {
                    vex.setTarget((LivingEntity)targetEntity);
                }
                vex.setPersistent(false);
            }
        });
    }

    @Nullable
    private Location traceForFangLocation(Location startingLocation, int step, double maxY, double minY) {
        World world = startingLocation.getWorld();
        Location currentLocation = startingLocation.clone();
        Location foundLocation = null;
        while (currentLocation.getY() >= minY && currentLocation.getY() <= maxY) {
            Block blockBelow = world.getBlockAt(currentLocation.clone().add(0.0, -1.0, 0.0));
            Block blockCurrent = world.getBlockAt(currentLocation);
            if (!blockCurrent.isCollidable() && blockBelow.isCollidable()) {
                double boundingBoxMaxY = 0.0;
                for (BoundingBox boundingBox : blockBelow.getCollisionShape().getBoundingBoxes()) {
                    if (!(boundingBox.getMaxY() > boundingBoxMaxY)) continue;
                    boundingBoxMaxY = boundingBox.getMaxY();
                }
                Location found = currentLocation.clone();
                found.setY((double)blockBelow.getY() + boundingBoxMaxY);
                foundLocation = found;
                break;
            }
            currentLocation.add(0.0, (double)step, 0.0);
        }
        return foundLocation;
    }

    private void doSummonFangs(Player player, @Nullable Entity targetEntity) {
        Location playerLocation = player.getLocation();
        Vector eyeDirection = this.scaleVector2D(player.getEyeLocation().getDirection());
        World world = player.getWorld();
        int targetFangs = 16;
        double maxY = player.getY();
        double minY = player.getY();
        if (targetEntity != null) {
            maxY = Math.max(maxY, targetEntity.getY()) + 1.0;
            minY = Math.min(minY, targetEntity.getY()) - 1.0;
        } else {
            maxY += 1.0;
            minY -= 5.0;
        }
        boolean targetLocationIsHigher = targetEntity == null || targetEntity.getLocation().getY() > playerLocation.getY();
        int stepDirection = targetLocationIsHigher ? -1 : 1;
        for (int fangIndex = 1; fangIndex <= targetFangs; ++fangIndex) {
            Location traceStartLocation = playerLocation.clone().add(new Vector(eyeDirection.getX() * (double)fangIndex, 0.0, eyeDirection.getZ() * (double)fangIndex));
            traceStartLocation.setY(targetLocationIsHigher ? maxY : minY);
            Location targetLocation = this.traceForFangLocation(traceStartLocation, stepDirection, maxY, minY);
            if (targetLocation == null) break;
            EvokerFangs fang = (EvokerFangs)world.spawn(targetLocation, EvokerFangs.class, CreatureSpawnEvent.SpawnReason.CUSTOM);
            fang.setAttackDelay(fangIndex);
            fang.setOwner((LivingEntity)player);
        }
    }

    @Override
    public void executeDelayedSkill(Player player, DisguiseState state, NoOpConfiguration option) {
        state.getDisguiseWrapper().setAggressive(false);
        EvokerSkillDataRecord skillData = state.getSessionDataOr(SESSION_DATA_SUMMON_VEX, EvokerSkillDataRecord.class, new EvokerSkillDataRecord(false, null));
        state.removeSessionData(SESSION_DATA_SUMMON_VEX);
        if (skillData.shouldSummonVex) {
            this.doSummonVex(player, skillData.lastTargetedEntity, state);
        } else {
            this.doSummonFangs(player, player.getTargetEntity(16));
        }
    }

    private Vector scaleVector2D(Vector vec) {
        double maxAbs = Math.max(Math.abs(vec.getX()), Math.abs(vec.getZ()));
        return vec.clone().divide(new Vector(maxAbs, 1.0, maxAbs));
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return SkillNames.EVOKER;
    }

    public static class VexHolderCounter {
        private final List<MorphBukkitVexHolder> list = ObjectLists.synchronize((ObjectList)new ObjectArrayList());

        public void addHolder(MorphBukkitVexHolder vex) {
            this.list.add(vex);
        }

        public void removeHolder(MorphBukkitVexHolder vex) {
            this.list.remove(vex);
        }

        public int countAlive() {
            return this.list.stream().filter(holder -> !holder.getVex().isDead()).toArray().length;
        }

        public void kill(int amount) {
            this.kill(amount, false);
        }

        public void kill(int amount, boolean immediate) {
            if (this.list.size() < amount) {
                amount = this.list.size();
            }
            for (int i = 0; i < amount; ++i) {
                MorphBukkitVexHolder holder = this.list.removeFirst();
                Vex vex = holder.getVex();
                if (immediate) {
                    vex.setHealth(0.0);
                } else {
                    vex.getScheduler().run((Plugin)FeatherMorphMain.getInstance(), task -> vex.setHealth(0.0), () -> {});
                }
                vex.getScheduler().runDelayed((Plugin)FeatherMorphMain.getInstance(), task -> {
                    if (!vex.isDead()) {
                        vex.remove();
                    }
                }, () -> {}, 60L);
            }
            this.trim();
        }

        public void killAll() {
            this.kill(this.list.size());
        }

        public void trim() {
            this.list.removeIf(holder -> holder.getVex().isDead());
        }
    }

    public record EvokerSkillDataRecord(boolean shouldSummonVex, @Nullable Entity lastTargetedEntity) {
    }
}

