/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.api;

import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.api.APIMeta;
import xyz.nifeather.morph.api.direct.FeatherMorphDirectAccess;
import xyz.nifeather.morph.api.networking.PlayerConnection;
import xyz.nifeather.morph.api.utilties.v0.UtilitiesAlpha;

@ApiStatus.Experimental
public class FeatherMorphAPI {
    @Nullable
    private static FeatherMorphAPI instance;
    private static final CompletableFuture<FeatherMorphAPI> apiFuture;
    private static final CompletableFuture<Object> panicFuture;
    @NotNull
    private final FeatherMorphMain plugin;
    private final FeatherMorphDirectAccess directAccess;
    private final UtilitiesAlpha utilsAlpha;
    private final PlayerConnection playerConnection;
    private final APIMeta apiMeta;

    @Nullable
    public static FeatherMorphAPI instance() {
        return instance;
    }

    @Deprecated(forRemoval=true)
    public static void runWhenAPILoaded(Runnable runnable) {
        FeatherMorphAPI.getApiFuture().thenAccept(api -> runnable.run());
    }

    public static CompletableFuture<FeatherMorphAPI> getApiFuture() {
        CompletableFuture<FeatherMorphAPI> listeningFuture = new CompletableFuture<FeatherMorphAPI>();
        apiFuture.exceptionally(e -> {
            listeningFuture.completeExceptionally((Throwable)e);
            return null;
        });
        apiFuture.thenAccept(listeningFuture::complete);
        return listeningFuture;
    }

    @ApiStatus.Internal
    public static void panic() {
        panicFuture.completeExceptionally(new Exception("Plugin Panic"));
    }

    public static void listenForPluginPanic(Runnable runnable) {
        panicFuture.exceptionally(e -> {
            runnable.run();
            return null;
        });
    }

    public FeatherMorphAPI(FeatherMorphMain plugin) {
        Logger logger = plugin.getSLF4JLogger();
        logger.info("Running init for FeatherMorphAPI...");
        this.plugin = plugin;
        this.directAccess = new FeatherMorphDirectAccess(plugin);
        this.utilsAlpha = new UtilitiesAlpha(this.directAccess);
        this.playerConnection = new PlayerConnection(this);
        this.apiMeta = new APIMeta();
        instance = this;
        apiFuture.complete(this);
        logger.info("Done running init for FeatherMorphAPI");
    }

    public APIMeta getMeta() {
        return this.apiMeta;
    }

    public FeatherMorphDirectAccess directAccess() {
        return this.directAccess;
    }

    public UtilitiesAlpha utilitiesAlpha() {
        return this.utilsAlpha;
    }

    public PlayerConnection playerConnection() {
        return this.playerConnection;
    }

    static {
        apiFuture = new CompletableFuture();
        panicFuture = new CompletableFuture();
    }
}

