/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.api.direct;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.abilities.AbilityManager;
import xyz.nifeather.morph.interfaces.IManageRequests;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Managers.DependencyManager;
import xyz.nifeather.morph.skills.SkillManager;

public class FeatherMorphDirectAccess {
    private final FeatherMorphMain plugin;
    private final DependencyManager dependencyManager;
    private final MorphManager morphManager;
    private final SkillManager skillHandler;
    private final AbilityManager abilityManager;
    private final IManageRequests requestManager;
    private final MorphClientHandler clientHandler;
    private final RevealingHandler revealingHandler;

    public FeatherMorphDirectAccess(FeatherMorphMain pl) {
        this.plugin = pl;
        this.dependencyManager = DependencyManager.getInstance(pl.getNamespace());
        this.morphManager = this.dependencyManager.get(MorphManager.class, true);
        this.skillHandler = this.dependencyManager.get(SkillManager.class, true);
        this.abilityManager = this.dependencyManager.get(AbilityManager.class, true);
        this.requestManager = this.dependencyManager.get(IManageRequests.class, true);
        this.clientHandler = this.dependencyManager.get(MorphClientHandler.class, true);
        this.revealingHandler = this.dependencyManager.get(RevealingHandler.class, true);
    }

    public FeatherMorphMain plugin() {
        return this.plugin;
    }

    public MorphManager morphManager() {
        return this.morphManager;
    }

    public RevealingHandler revealingHandler() {
        return this.revealingHandler;
    }

    public SkillManager skillHandler() {
        return this.skillHandler;
    }

    public AbilityManager abilityManager() {
        return this.abilityManager;
    }

    public IManageRequests requestManager() {
        return this.requestManager;
    }

    public MorphClientHandler clientHandler() {
        return this.clientHandler;
    }

    @NotNull
    public <T> T getGlobalDependency(Class<T> clazz) {
        return this.getGlobalDependency(clazz, true);
    }

    @Nullable
    public <T> T getGlobalDependency(Class<T> clazz, boolean throwIfNotFound) {
        return this.dependencyManager.get(clazz, throwIfNotFound);
    }
}

