/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.github.retrooper.packetevents.protocol.component.builtin.item.ItemProfile;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.pose.EntityPose;
import com.github.retrooper.packetevents.protocol.player.PlayerModelType;
import com.github.retrooper.packetevents.resources.ResourceLocation;
import com.github.retrooper.packetevents.util.Vector3i;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.ExecutionErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;

public class MannequinWatcher
extends LivingEntityWatcher {
    private volatile boolean hideDescription = false;

    public MannequinWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.MANNEQUIN);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.MANNEQUIN);
    }

    @Override
    protected byte getPlayerBitMask(Player player) {
        byte bitMask = super.getPlayerBitMask(player);
        if ((bitMask & 2) == 2) {
            bitMask = (byte)(bitMask ^ 2);
        }
        return bitMask;
    }

    @Override
    protected List<EntityData<?>> handleEntityMetadata(@Unmodifiable List<EntityData<?>> originalData, List<EntityData<?>> currentData) throws ExecutionErrorException {
        if (currentData.removeIf(ValueIndex.MANNEQUIN.GENERAL::equals)) {
            currentData.add(new EntityData(ValueIndex.MANNEQUIN.GENERAL.index(), ValueIndex.MANNEQUIN.GENERAL.type(), (Object)this.getPlayerBitMask(this.getBindingPlayer())));
        }
        return super.handleEntityMetadata(originalData, currentData);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        switch (property.id()) {
            case "mannequin/skin": {
                ResolvableProfile resolvable = (ResolvableProfile)value;
                this.writePersistent(ValueIndex.MANNEQUIN.SKIN_PROFILE, MannequinWatcher.itemProfile(resolvable));
                break;
            }
            case "mannequin/hide_description": {
                this.hideDescription = (Boolean)value;
                Component existingDescription = this.readOr(ValueIndex.MANNEQUIN.DESCRIPTION, Optional.empty()).orElse(null);
                this.updateDescription(this.hideDescription, existingDescription);
                break;
            }
            case "mannequin/description": {
                this.updateDescription(this.hideDescription, (Component)value);
            }
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId;
            switch (animId = String.valueOf(newVal)) {
                case "lay": {
                    this.remove(ValueIndex.MANNEQUIN.POSE);
                    this.writePersistent(ValueIndex.MANNEQUIN.POSE, EntityPose.SLEEPING);
                    Location playerPos = this.getBindingPlayer().getLocation();
                    Vector3i vec3i = new Vector3i(playerPos.getBlockX(), playerPos.getBlockY(), playerPos.getBlockZ());
                    this.writePersistent(ValueIndex.MANNEQUIN.BED_POS, Optional.of(vec3i));
                    break;
                }
                case "crawl": {
                    this.resetValues();
                    this.writePersistent(ValueIndex.MANNEQUIN.POSE, EntityPose.SWIMMING);
                    break;
                }
                case "standup": 
                case "reset": {
                    this.writePersistent(ValueIndex.MANNEQUIN.POSE, SpigotConversionUtil.fromBukkitPose((Pose)this.getBindingPlayer().getPose()));
                    this.resetValues();
                }
            }
        }
    }

    private void resetValues() {
        this.remove(ValueIndex.MANNEQUIN.POSE);
        this.writePersistent(ValueIndex.MANNEQUIN.BED_POS, Optional.empty());
        this.remove(ValueIndex.MANNEQUIN.BED_POS);
    }

    public void updateDescription(boolean hideDescription, @Nullable Component description) {
        this.writePersistent(ValueIndex.MANNEQUIN.DESCRIPTION, hideDescription ? Optional.empty() : Optional.ofNullable(description));
    }

    public static ItemProfile itemProfile(ResolvableProfile resolvableProfile) {
        ArrayList<ItemProfile.Property> properties = new ArrayList<ItemProfile.Property>();
        for (ProfileProperty bukkitProperty : resolvableProfile.properties()) {
            ItemProfile.Property peProperty = new ItemProfile.Property(bukkitProperty.getName(), bukkitProperty.getValue(), bukkitProperty.getSignature());
            properties.add(peProperty);
        }
        ResolvableProfile.SkinPatch bukkitSkinPatch = resolvableProfile.skinPatch();
        ItemProfile.SkinPatch skinPatch = new ItemProfile.SkinPatch(MannequinWatcher.fromAdventureKey(bukkitSkinPatch.body()), MannequinWatcher.fromAdventureKey(bukkitSkinPatch.cape()), MannequinWatcher.fromAdventureKey(bukkitSkinPatch.elytra()), MannequinWatcher.playerModelType(bukkitSkinPatch.model()));
        return new ItemProfile(resolvableProfile.name(), resolvableProfile.uuid(), properties, skinPatch);
    }

    @Nullable
    public static PlayerModelType playerModelType(@Nullable PlayerTextures.SkinModel model) {
        if (model == null) {
            return null;
        }
        return switch (model) {
            default -> throw new MatchException(null, null);
            case PlayerTextures.SkinModel.CLASSIC -> PlayerModelType.WIDE;
            case PlayerTextures.SkinModel.SLIM -> PlayerModelType.SLIM;
        };
    }

    @Nullable
    public static ResourceLocation fromAdventureKey(@Nullable Key key) {
        return key == null ? null : new ResourceLocation(key);
    }
}

