/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.brigadier.arguments.DisguiseIdentifierArgumentType;
import xyz.nifeather.morph.commands.brigadier.arguments.ValueMapArgumentType;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.messages.strings.MorphStrings;
import xyz.nifeather.morph.misc.MorphParameters;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.gui.DisguiseSelectScreenWrapper;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class MorphCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager morphManager;
    private final ValueMapArgumentType propertyArgument = new ValueMapArgumentType();

    @Override
    @NotNull
    public String name() {
        return "morph";
    }

    @Override
    public boolean register(Commands dispatcher) {
        dispatcher.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).executes(this::executeNoArg)).then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)DisguiseIdentifierArgumentType.FOR_PLAYER).executes(this::execWithID)).then(Commands.argument((String)"properties", (ArgumentType)this.propertyArgument).executes(this::execWithProperties)))).build());
        return true;
    }

    @Initializer
    private void load() {
        DisguiseProperties.INSTANCE.getAll().forEach((type, properties) -> {
            for (SingleProperty<?> property : properties.getRegisteredProperties().values()) {
                if (property.hideFromUserInput()) continue;
                String name = property.id();
                List<String> values = property.validInputs();
                this.propertyArgument.setProperty(name, values);
            }
        });
    }

    public int executeNoArg(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        if (!this.morphManager.canMorph(player)) {
            MessageUtils.send((CommandSender)player, MorphStrings.disguiseCoolingDownString());
            return 1;
        }
        DisguiseSelectScreenWrapper gui = new DisguiseSelectScreenWrapper(player);
        gui.show();
        return 1;
    }

    private int execWithID(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(executor instanceof Player)) {
            MessageUtils.send(sender, "Only players can execute disguise command");
            return 1;
        }
        Player player = (Player)executor;
        String inputID = DisguiseIdentifierArgumentType.getArgument(context, "id");
        this.doDisguise(((CommandSourceStack)context.getSource()).getSender(), player, inputID, null);
        return 1;
    }

    private void doDisguise(CommandSender sender, Player who, String id, @Nullable Map<String, String> properties) {
        if (!this.morphManager.canMorph(who)) {
            MessageUtils.send(sender, MorphStrings.disguiseCoolingDownString());
            return;
        }
        MorphParameters parameters = MorphParameters.create(who, id).setSource(sender).setTargetedEntity(who.getTargetEntity(5));
        if (properties != null) {
            parameters.withProperties(properties);
        }
        this.morphManager.morph(parameters);
    }

    private int execWithProperties(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(executor instanceof Player)) {
            MessageUtils.send(sender, "Only players can execute disguise command");
            return 1;
        }
        Player player = (Player)executor;
        Map<String, String> propertiesInput = ValueMapArgumentType.get("properties", context);
        String disguiseInput = DisguiseIdentifierArgumentType.getArgument(context, "id");
        this.doDisguise(sender, player, disguiseInput, propertiesInput);
        return 1;
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.morphDescription();
    }
}

