/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin.management;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.brigadier.arguments.DisguiseIdentifierArgumentType;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.CommonStrings;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class RevokeDisguiseSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager morphs;

    @Override
    @NotNull
    public String name() {
        return "revoke";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.manageRevokeDescription();
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.manage.revoke";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).then(Commands.argument((String)"who", (ArgumentType)ArgumentTypes.players()).then(Commands.argument((String)"id", (ArgumentType)DisguiseIdentifierArgumentType.ALL_AVAILABLE).executes(this::execute))));
    }

    private int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        List players = (List)((PlayerSelectorArgumentResolver)context.getArgument("who", PlayerSelectorArgumentResolver.class)).resolve((CommandSourceStack)context.getSource());
        players.forEach(who -> {
            Object targetName = DisguiseIdentifierArgumentType.getArgument(context, "id");
            CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
            if (!who.isOnline()) {
                MessageUtils.send(commandSender, CommonStrings.playerNotFoundString());
                return;
            }
            if (!((String)targetName).contains(":")) {
                targetName = "minecraft:" + (String)targetName;
            }
            String finalTargetName = targetName;
            DisguiseMeta info = this.morphs.getAvaliableDisguisesFor((Player)who).stream().filter(i -> i.getKey().equals(finalTargetName)).findFirst().orElse(null);
            boolean revokeSuccess = info != null && this.morphs.revokeMorphFromPlayer((Player)who, info.getKey());
            FormattableMessage msg = revokeSuccess ? CommandStrings.revokeSuccessString() : CommandStrings.revokeFailString();
            msg.resolve("what", (Component)Component.text((String)targetName)).resolve("who", who.getName());
            MessageUtils.send(commandSender, msg);
        });
        return 1;
    }
}

