/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEarlyEvent;
import xyz.nifeather.morph.api.events.gameplay.PlayerUnMorphEarlyEvent;
import xyz.nifeather.morph.config.ConfigOption;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.MorphParameters;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class ForcedDisguiseProcessor
extends MorphPluginObject
implements Listener {
    private final Bindable<String> forcedId = new Bindable<String>("@none");
    private final Bindable<Boolean> doForcedDisguise = new Bindable<Boolean>(false);
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;

    @Initializer
    private void load() {
        this.config.bind(this.forcedId, ConfigOption.FORCED_DISGUISE);
        this.forcedId.onValueChanged((o, n) -> {
            this.doForcedDisguise.set(!n.equals("@none"));
            if (this.doForcedDisguise.get().booleanValue()) {
                this.logger.info("Config changed, re-disguising players...");
                this.addSchedule(() -> {
                    List<Player> players = this.featherMorph().getPlatform().onlinePlayersNative();
                    players.forEach(p -> this.doDisguise((Player)p, (String)n));
                });
            }
        }, true);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.doForcedDisguise.get().booleanValue()) {
            this.doDisguise(e.getPlayer(), this.forcedId.get());
        }
    }

    private void doDisguise(Player player, String targetId) {
        MorphParameters parameters;
        boolean success;
        this.logger.info("Trying to disguise %s as %s".formatted(player.getName(), targetId));
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        if (state != null) {
            this.manager.unMorph((CommandSender)Bukkit.getConsoleSender(), player, true, true);
        }
        if (!(success = this.manager.morph(parameters = MorphParameters.create(player, targetId).setSource((CommandSender)Bukkit.getConsoleSender()).setBypassAvailableCheck(true).setBypassPermission(true)))) {
            this.logger.error("Unable to disguise %s as %s".formatted(player.getName(), targetId));
        }
    }

    @EventHandler
    public void onUnmorph(PlayerUnMorphEarlyEvent e) {
        if (!this.doForcedDisguise.get().booleanValue()) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onMorph(PlayerMorphEarlyEvent e) {
        if (!this.doForcedDisguise.get().booleanValue()) {
            return;
        }
        String id = e.getTargetId();
        if (id.equals(this.forcedId.get())) {
            return;
        }
        e.setCancelled(true);
    }
}

