/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityMountEvent;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.api.FeatherMorphAPI;
import xyz.nifeather.morph.api.events.gameplay.PlayerMorphEarlyEvent;
import xyz.nifeather.morph.misc.DisguiseState;

public class WorkaroundProcessor
extends MorphPluginObject
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMorph(PlayerMorphEarlyEvent event) {
        Player player = event.getPlayer();
        if (!event.getTargetId().equals(EntityType.CREAKING.key().asString())) {
            return;
        }
        List passengers = player.getPassengers();
        if (passengers.isEmpty()) {
            return;
        }
        passengers.forEach(arg_0 -> ((Player)player).removePassenger(arg_0));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityMount(EntityMountEvent event) {
        Entity matchingVehicle;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        MorphManager morphManager = FeatherMorphAPI.instance().directAccess().morphManager();
        DisguiseState playerDisguiseState = morphManager.getDisguiseStateFor(player);
        if (playerDisguiseState != null && playerDisguiseState.getEntityType() == EntityType.PLAYER) {
            playerDisguiseState.stopAnimations();
        }
        if ((matchingVehicle = this.findAnyVehicle(event.getMount(), entity -> {
            if (!(entity instanceof Player)) {
                return false;
            }
            Player vehiclePlayer = (Player)entity;
            DisguiseState theirState = morphManager.getDisguiseStateFor(vehiclePlayer);
            if (theirState == null) {
                return false;
            }
            return theirState.getEntityType() == EntityType.CREAKING;
        })) == null) {
            return;
        }
        Location mountLocation = player.getLocation();
        this.scheduleOn((Entity)player, () -> {
            if (!Objects.equals(player.getVehicle(), event.getMount())) {
                return;
            }
            player.leaveVehicle();
            player.teleportAsync(mountLocation);
        });
        event.setCancelled(true);
    }

    @Nullable
    private Entity findAnyVehicle(Entity topVehicle, Predicate<Entity> predicate) {
        if (topVehicle == null) {
            return null;
        }
        if (predicate.test(topVehicle)) {
            return topVehicle;
        }
        return this.findAnyVehicle(topVehicle.getVehicle(), predicate);
    }
}

