/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events.mirror.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.events.PlayerTracker;
import xyz.nifeather.morph.events.mirror.ExecutorHub;
import xyz.nifeather.morph.events.mirror.impl.ChainedExecutor;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.storage.mirrorlogging.OperationType;
import xyz.nifeather.morph.utilities.NmsUtils;

public class BySightExecutor
extends ChainedExecutor {
    public BySightExecutor(ExecutorHub executorHub) {
        super(executorHub);
    }

    @Override
    public void reset() {
    }

    @Override
    @Nullable
    protected Player findNextControllablePlayerFrom(Player source, List<Player> pendingChain) {
        String targetName = this.getTargetControlFor(source);
        if (targetName == null) {
            return null;
        }
        Entity targetEntity = source.getTargetEntity(5);
        if (!(targetEntity instanceof Player)) {
            return null;
        }
        Player targetPlayer = (Player)targetEntity;
        if (!NmsUtils.isTickThreadFor((Entity)targetPlayer)) {
            return null;
        }
        if (!this.playerInDistance(source, targetPlayer)) {
            return null;
        }
        DisguiseState state = this.morphManager().getDisguiseStateFor(targetPlayer);
        if (state != null && state.getDisguiseIdentifier().equals("player:" + targetName)) {
            return targetPlayer;
        }
        if (targetPlayer.getName().equals(targetName) && state == null) {
            return targetPlayer;
        }
        return null;
    }

    @Override
    public boolean onHurtEntity(Player damager, Player hurted) {
        Player simulateTarget = this.findNextControllablePlayerFrom(damager, (List)this.currentSimulateChain.get());
        if (simulateTarget == null) {
            return false;
        }
        Entity damagerLookingAt = damager.getTargetEntity(5);
        Entity playerLookingAt = simulateTarget.getTargetEntity(5);
        if (damagerLookingAt != null && damagerLookingAt.equals((Object)playerLookingAt)) {
            return true;
        }
        return hurted.equals((Object)simulateTarget);
    }

    @Override
    public boolean onSwing(Player source) {
        boolean isInChain = this.isInChain(source);
        if (isInChain) {
            return !this.isLastInChain(source);
        }
        PlayerTracker tracker = this.tracker();
        if (tracker.droppingItemThisTick(source)) {
            return false;
        }
        PlayerTracker.InteractType lastAction = tracker.getLastInteractAction(source);
        if (!tracker.interactingThisTick(source)) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_AIR;
        }
        if (lastAction == null) {
            return false;
        }
        if (source.getGameMode() == GameMode.SPECTATOR && lastAction.isRightClick()) {
            lastAction = PlayerTracker.InteractType.LEFT_CLICK_BLOCK;
        }
        PlayerTracker.InteractType finalLastAction = lastAction;
        AtomicBoolean simulateSuccess = new AtomicBoolean(false);
        this.runIfChainable(source, targetPlayer -> {
            simulateSuccess.set(true);
            this.simulateOperation(finalLastAction.toBukkitAction(), (Player)targetPlayer, source);
            this.logOperation(source, (Player)targetPlayer, finalLastAction.isLeftClick() ? OperationType.LeftClick : OperationType.RightClick);
        });
        return simulateSuccess.get();
    }
}

