/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.messages;

import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.messages.MorphMessageStore;
import xyz.nifeather.morph.shaded.pluginbase.Messages.IStrings;
import xyz.nifeather.morph.shaded.pluginbase.Messages.MessageStore;
import xyz.nifeather.morph.utilities.PluginAssetUtils;

public class MorphMessageSubStore
extends MessageStore<FeatherMorphMain> {
    private final List<Class<? extends IStrings>> strings;
    private final String locale;
    private final MorphMessageStore parentStore;
    private boolean overwriteNonDef;
    private final Map<String, String> assets;

    public MorphMessageSubStore(String locale, List<Class<? extends IStrings>> strings, MorphMessageStore parentStore) {
        this.locale = locale;
        this.strings = strings;
        this.parentStore = parentStore;
        String path = PluginAssetUtils.langPath(locale);
        String asset = PluginAssetUtils.getFileStrings(path);
        this.assets = (Map)this.createGson().fromJson(asset, ((Map)this.storingObject).getClass());
    }

    @Override
    @NotNull
    protected Map<String, String> createDefault() {
        return new ConcurrentHashMap<String, String>();
    }

    public void overWriteNonDefaultAfterReload() {
        this.overwriteNonDef = true;
    }

    @Override
    public void addMissingStrings() {
        String path = PluginAssetUtils.langPath(this.locale);
        String asset = PluginAssetUtils.getFileStrings(path);
        if (!asset.isBlank()) {
            try {
                Map defaults = (Map)this.createGson().fromJson(asset, ((Map)this.storingObject).getClass());
                defaults.forEach((o1, o2) -> {
                    String key;
                    block5: {
                        block4: {
                            if (!(o1 instanceof String)) break block4;
                            key = (String)o1;
                            if (o2 instanceof String) break block5;
                        }
                        return;
                    }
                    String msg = (String)o2;
                    if (!((Map)this.storingObject).containsKey(key) || this.overwriteNonDef && !((Map)this.storingObject).getOrDefault(key, "").equals(msg)) {
                        ((Map)this.storingObject).put(key, msg);
                    }
                });
            }
            catch (JsonSyntaxException e) {
                this.logger.error("Error occurred while updating localization for locale '" + this.locale + "'", (Throwable)e);
            }
        }
        this.saveConfiguration();
    }

    @Override
    protected List<Class<? extends IStrings>> getStrings() {
        return this.strings;
    }

    @Override
    @NotNull
    protected String getFileName() {
        return "messages/" + this.locale + ".json";
    }

    @Override
    protected String getPluginNamespace() {
        return FeatherMorphMain.getMorphNameSpace();
    }
}

