/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class CowProperties
extends BaseLivingEntityProperties<Cow> {
    private final Map<String, Cow.Variant> variantMap = new ConcurrentHashMap<String, Cow.Variant>();
    public final SingleProperty<Cow.Variant> VARIANT;

    public CowProperties() {
        for (Cow.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.COW_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
        this.VARIANT = this.createProperty("cow/variant", Cow.Variant.TEMPERATE, this::readCowVariant, OutputHandles::writeKeyed).withRandom(this.variantMap.values()).withValidInput(this.variantMap.keySet());
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    private Optional<Cow.Variant> readCowVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.COW_VARIANT, propertyName, string);
    }

    @Override
    @Nullable
    protected Cow tryCastEntity(@Nullable Entity targetEntity) {
        Cow cow;
        return targetEntity instanceof Cow ? (cow = (Cow)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Cow cow) {
        super.setupPropertiesFromEntity(meta, propertyHandler, cow);
        propertyHandler.set(this.VARIANT, cow.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.getRandomValues()));
    }
}

