/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Rabbit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class RabbitProperties
extends BaseLivingEntityProperties<Rabbit> {
    private final Map<String, Rabbit.Type> typeMap = new ConcurrentHashMap<String, Rabbit.Type>();
    public final SingleProperty<Rabbit.Type> VARIANT = this.createProperty("rabbit/variant", Rabbit.Type.BROWN, this::readVariant, OutputHandles::writeEnum).withRandom((Rabbit.Type[])Rabbit.Type.values());

    private void initMap() {
        for (Rabbit.Type type : Rabbit.Type.values()) {
            this.typeMap.put(type.name().toLowerCase(), type);
        }
    }

    private Optional<Rabbit.Type> readVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Rabbit.Type.values(), (String)propertyName, (String)string);
    }

    public RabbitProperties() {
        this.initMap();
        this.VARIANT.withValidInput(this.typeMap.keySet());
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    @Override
    @Nullable
    protected Rabbit tryCastEntity(@Nullable Entity targetEntity) {
        Rabbit rabbit;
        return targetEntity instanceof Rabbit ? (rabbit = (Rabbit)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Rabbit targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.VARIANT, targetEntity.getRabbitType());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.getRandomValues()));
    }
}

