/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityProperties;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class ZombieVillagerProperties
extends BaseLivingEntityProperties<ZombieVillager> {
    private final Map<String, Villager.Type> typeMap = new ConcurrentHashMap<String, Villager.Type>();
    private final Map<String, Villager.Profession> professionMap = new ConcurrentHashMap<String, Villager.Profession>();
    public final SingleProperty<Villager.Type> TYPE = this.createProperty("zombie_villager/type", Villager.Type.PLAINS, InputHandles::readVillagerType, OutputHandles::writeKeyed).withRandom(Registry.VILLAGER_TYPE.stream().toList());
    public final SingleProperty<Villager.Profession> PROFESSION = this.createProperty("zombie_villager/profession", Villager.Profession.NONE, InputHandles::readVillagerProfession, OutputHandles::writeKeyed).withRandom(Registry.VILLAGER_PROFESSION.stream().toList());
    public final SingleProperty<Integer> LEVEL = this.createProperty("zombie_villager/level", 1, InputHandles::readVillagerLevel, OutputHandles::writeInteger).withRandom((Integer[])new Integer[]{1, 2, 3, 4, 5, 6});
    public final SingleProperty<Boolean> IS_BABY = this.createProperty("zombie_villager/is_baby", false, InputHandles::readBooleanRelaxed, OutputHandles::writeBoolean);

    private void initMaps() {
        for (Villager.Type type : Registry.VILLAGER_TYPE) {
            this.typeMap.put(type.key().asString(), type);
        }
        for (Villager.Profession profession : Registry.VILLAGER_PROFESSION) {
            this.professionMap.put(profession.key().asString(), profession);
        }
    }

    public ZombieVillagerProperties() {
        this.initMaps();
        this.TYPE.withValidInput(this.typeMap.keySet());
        this.PROFESSION.withValidInput(this.professionMap.keySet());
        this.registerSingle(this.TYPE, this.PROFESSION, this.IS_BABY, this.LEVEL);
    }

    @Override
    @Nullable
    protected ZombieVillager tryCastEntity(@Nullable Entity targetEntity) {
        ZombieVillager villager;
        return targetEntity instanceof ZombieVillager ? (villager = (ZombieVillager)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull ZombieVillager targetEntity) {
        super.setupPropertiesFromEntity(meta, propertyHandler, targetEntity);
        propertyHandler.set(this.TYPE, targetEntity.getVillagerType());
        propertyHandler.set(this.PROFESSION, targetEntity.getVillagerProfession());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.TYPE, DisguiseUtils.pick(this.TYPE.getRandomValues()));
        propertyHandler.set(this.PROFESSION, DisguiseUtils.pick(this.PROFESSION.getRandomValues()));
    }
}

