/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.C2S;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.network.BasicClientHandler;
import xyz.nifeather.morph.network.annotations.Environment;
import xyz.nifeather.morph.network.annotations.EnvironmentType;
import xyz.nifeather.morph.network.commands.C2S.AbstractC2SCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class C2SMorphCommand
extends AbstractC2SCommand<String> {
    @NotNull
    private final String identifier;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private static final Gson gson = new GsonBuilder().create();

    public String identifier() {
        return this.identifier;
    }

    public Map<String, String> propertyInputs() {
        return Map.copyOf(this.properties);
    }

    public C2SMorphCommand(@Nullable String identifier, Map<String, String> propertyInputs) {
        this.identifier = identifier == null ? "" : identifier;
        this.properties.putAll(propertyInputs);
    }

    public static C2SMorphCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (arguments.containsKey("properties")) {
            ((Map)gson.fromJson(Asserts.getStringOrThrow(arguments, "properties"), Map.class)).forEach((k, v) -> properties.put("" + k, "" + v));
        }
        return new C2SMorphCommand(Asserts.getStringOrThrow(arguments, "id"), properties);
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("id", this.identifier, "properties", gson.toJson(this.properties));
    }

    @Override
    public String getBaseName() {
        return "morph";
    }

    @Override
    @Environment(value=EnvironmentType.SERVER)
    public void onCommand(BasicClientHandler<?> listener) {
        listener.onMorphCommand(this);
    }
}

