/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.S2C.clientrender;

import java.util.Map;
import xyz.nifeather.morph.network.BasicServerHandler;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.utils.Asserts;

public class S2CCRRegisterCommand
extends AbstractS2CCommand<String> {
    private int networkId;
    private String mobId;
    private static final S2CCRRegisterCommand invalidPacket = new S2CCRRegisterCommand(-1, null);

    public S2CCRRegisterCommand(Integer playerNetworkId, String mobId) {
        this.networkId = playerNetworkId;
        this.mobId = mobId;
    }

    public static S2CCRRegisterCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        return new S2CCRRegisterCommand(Integer.parseInt(Asserts.getStringOrThrow(arguments, "player_id")), Asserts.getStringOrThrow(arguments, "mob_id"));
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("player_id", Integer.toString(this.networkId), "mob_id", this.mobId);
    }

    @Override
    public String getBaseName() {
        return "cr_add";
    }

    @Override
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onClientMapAddCommand(this);
    }

    public boolean isValid() {
        return !this.mobId.isBlank();
    }

    public int getPlayerNetworkId() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Trying to get a network id from an invalid packet.");
        }
        return this.networkId;
    }

    public String getMobId() {
        if (!this.isValid()) {
            throw new IllegalArgumentException("Trying to get mob id from an invalid packet.");
        }
        return this.mobId;
    }

    public static S2CCRRegisterCommand of(Integer networkId, String mobId) {
        return new S2CCRRegisterCommand(networkId, mobId);
    }

    public static S2CCRRegisterCommand of(String arg) {
        String[] argSplit = arg.split(" ");
        if (argSplit.length < 2) {
            return invalidPacket;
        }
        int networkId = -1;
        try {
            networkId = Integer.parseInt(argSplit[0]);
        }
        catch (Throwable t) {
            return invalidPacket;
        }
        return S2CCRRegisterCommand.of(networkId, argSplit[1]);
    }
}

