/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.commands.S2C.query;

import java.util.List;
import java.util.Map;
import xyz.nifeather.morph.network.BasicServerHandler;
import xyz.nifeather.morph.network.annotations.Environment;
import xyz.nifeather.morph.network.annotations.EnvironmentType;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.query.QueryType;
import xyz.nifeather.morph.network.utils.Asserts;

public class S2CQueryCommand
extends AbstractS2CCommand<String> {
    private final QueryType queryType;
    private final List<String> diff;

    public static S2CQueryCommand fromArguments(Map<String, String> arguments) throws RuntimeException {
        QueryType type = QueryType.tryValueOf(Asserts.getStringOrThrow(arguments, "type"));
        return new S2CQueryCommand(type, Asserts.getStringListOrThrow(arguments, "diff"));
    }

    @Override
    public Map<String, String> generateArgumentMap() {
        return Map.of("type", this.queryType.name(), "diff", S2CQueryCommand.gson().toJson(this.diff));
    }

    public S2CQueryCommand(QueryType queryType, List<String> diff) {
        this.diff = diff;
        this.queryType = queryType;
    }

    public QueryType queryType() {
        return this.queryType;
    }

    public List<String> getDiff() {
        return this.diff;
    }

    @Override
    public String getBaseName() {
        return "query";
    }

    @Override
    @Environment(value=EnvironmentType.CLIENT)
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onQueryCommand(this);
    }
}

