/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.server;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.network.ConnectionState;
import xyz.nifeather.morph.network.InitializeState;
import xyz.nifeather.morph.network.PlayerOptions;

public class PlayerSession {
    public volatile int apiVersion;
    public final PlayerOptions<Player> options;
    @NotNull
    public volatile InitializeState initializeState = InitializeState.NOT_CONNECTED;
    @NotNull
    public volatile ConnectionState connectionState = ConnectionState.NOT_CONNECTED;
    public final List<String> clientFeatures = new CopyOnWriteArrayList<String>();

    public PlayerSession(Player bindingPlayer, List<String> clientFeatures) {
        this.options = new PlayerOptions<Player>(bindingPlayer);
        this.clientFeatures.addAll(clientFeatures);
    }

    public static final class SessionBuilder {
        private final List<String> features = new CopyOnWriteArrayList<String>();
        private final Player bindingPlayer;

        public static SessionBuilder builder(Player player) {
            return new SessionBuilder(player);
        }

        public SessionBuilder(Player bindingPlayer) {
            this.bindingPlayer = bindingPlayer;
        }

        public SessionBuilder withClientFeature(List<String> list) {
            this.features.addAll(list);
            return this;
        }

        public PlayerSession build() {
            return new PlayerSession(this.bindingPlayer, List.copyOf(this.features));
        }
    }
}

