/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.providers.disguise;

import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.backends.DisguiseBackend;
import xyz.nifeather.morph.backends.DisguiseWrapper;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.values.AbstractProperties;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.providers.animation.AnimationProvider;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public abstract class DisguiseProvider
extends MorphPluginObject {
    @Resolved
    private MorphManager morphs;

    @NotNull
    public abstract String getNameSpace();

    public abstract AnimationProvider getAnimationProvider();

    public abstract boolean isValid(String var1);

    public abstract List<String> getAllAvailableDisguises();

    @NotNull
    public abstract Optional<DisguiseWrapper<?>> makeWrapper(Player var1, DisguiseMeta var2, @Nullable Entity var3);

    public abstract boolean updateDisguise(Player var1, DisguiseState var2);

    public void setupProperties(DisguiseState state, @Nullable Entity targetEntity) {
        AbstractProperties<?> matchingProperty = DisguiseProperties.INSTANCE.get(state.getEntityType());
        matchingProperty.setupProperties(state, targetEntity);
    }

    public void finalizeProperties(DisguiseState state) throws ParseErrorException {
    }

    @NotNull
    public abstract List<AbstractS2CCommand<?>> getInitialSyncCommands(DisguiseState var1);

    public boolean validForClient(DisguiseState state) {
        return false;
    }

    @NotNull
    public abstract DisguiseBackend<?, ?> getPreferredBackend();

    public boolean unMorph(Player player, DisguiseState state) {
        return this.getPreferredBackend().unDisguise(player);
    }

    protected MorphManager getMorphManager() {
        return this.morphs;
    }

    public abstract boolean canCloneEquipment(DisguiseMeta var1, Entity var2, DisguiseState var3);

    public void buildDisguise(DisguiseState state, @Nullable Entity targetEntity) throws ParseErrorException {
    }

    public void onDisguiseApply(DisguiseState state) {
    }

    public void onPlayerJoinWithDisguise(DisguiseState state) {
    }

    public void onPlayerQuitWithDisguise(DisguiseState state) {
    }

    public abstract Component getDisplayName(String var1, @Nullable String var2);

    public boolean validateDisguise(Player player, DisguiseMeta disguiseMeta, Entity targetEntity) {
        return true;
    }
}

