/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.skills.options;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class ExplosionConfiguration
implements ISkillAbilityOption {
    public static final ExplosionOptionHandler OPTION_HANDLER = new ExplosionOptionHandler();
    private final boolean killsSelf;
    public int executeDelay;
    private final int strength;
    private final boolean setsFire;
    public final String primedSound;

    public ExplosionConfiguration(boolean killsSelf, int strength, boolean setsFire, int delay, String primedSound) {
        this.killsSelf = killsSelf;
        this.strength = strength;
        this.setsFire = setsFire;
        this.executeDelay = delay;
        this.primedSound = primedSound;
    }

    public boolean killsSelf() {
        return this.killsSelf;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean setsFire() {
        return this.setsFire;
    }

    public String getPrimedSound() {
        return this.primedSound == null ? "" : this.primedSound;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static class ExplosionOptionHandler
    implements ISkillAbilityOptionHandler<ExplosionConfiguration> {
        @Override
        public Class<ExplosionConfiguration> getOptionClass() {
            return ExplosionConfiguration.class;
        }

        @Override
        public void writeOption(ExplosionConfiguration option, @NotNull Map<String, Object> gsonMap) {
            gsonMap.put("kills_self", option.killsSelf());
            gsonMap.put("strength", option.getStrength());
            gsonMap.put("sets_fire", option.setsFire());
            gsonMap.put("delay", option.executeDelay);
            gsonMap.put("primed_sound", option.getPrimedSound());
        }

        @Override
        @NotNull
        public ExplosionConfiguration readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            boolean killsSelf = this.utilGetTypedOrThrow("kills_self", gsonMap, Boolean.class);
            int strength = this.utilGetTypedOrThrow("strength", gsonMap, Number.class).intValue();
            boolean setsFire = this.utilGetTypedOrThrow("sets_fire", gsonMap, Boolean.class);
            int delay = this.utilGetTypedOrThrow("delay", gsonMap, Number.class).intValue();
            String primedSound = this.utilGetTypedOrThrow("primed_sound", gsonMap, String.class);
            return new ExplosionConfiguration(killsSelf, strength, setsFire, delay, primedSound);
        }
    }
}

