/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.storage.offlinestore;

import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.interfaces.IManageOfflineStates;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseStateGenerator;
import xyz.nifeather.morph.storage.MorphJsonBasedStorage;
import xyz.nifeather.morph.storage.offlinestore.OfflineDisguiseState;
import xyz.nifeather.morph.storage.offlinestore.OfflineStateContainer;

public class OfflineStateStore
extends MorphJsonBasedStorage<OfflineStateContainer>
implements IManageOfflineStates {
    @Override
    @NotNull
    protected String getFileName() {
        return "offline_store.json";
    }

    @Override
    @NotNull
    protected OfflineStateContainer createDefault() {
        return new OfflineStateContainer();
    }

    @Override
    @NotNull
    protected String getDisplayName() {
        return "\u79bb\u7ebf\u5b58\u50a8";
    }

    @Override
    public void pushDisguiseState(DisguiseState state) {
        UUID uniqueId = state.getPlayer().getUniqueId();
        if (((OfflineStateContainer)this.storingObject).disguiseStates.stream().anyMatch(s -> s.playerUUID.equals(uniqueId))) {
            this.logger.warn("\u5c06\u653e\u5f03\u5b58\u50a8\u4e2d\u5df2\u6709\u7684" + String.valueOf(uniqueId) + "\u6761\u76ee...");
            ((OfflineStateContainer)this.storingObject).disguiseStates.removeIf(s -> s.playerUUID.equals(uniqueId));
        }
        ((OfflineStateContainer)this.storingObject).disguiseStates.add(DisguiseStateGenerator.toOfflineState(state));
    }

    @Override
    public List<OfflineDisguiseState> getAvaliableDisguiseStates() {
        return ((OfflineStateContainer)this.storingObject).disguiseStates;
    }

    @Override
    @Nullable
    public OfflineDisguiseState popDisguiseState(UUID uuid) {
        OfflineDisguiseState state = ((OfflineStateContainer)this.storingObject).disguiseStates.stream().filter(s -> s.playerUUID.equals(uuid)).findFirst().orElse(null);
        if (state != null) {
            ((OfflineStateContainer)this.storingObject).disguiseStates.remove(state);
            this.saveConfiguration();
            return state;
        }
        return null;
    }
}

