/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.fmccl.network.commands.S2C.query;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.fmccl.network.BasicServerHandler;
import xyz.nifeather.fmccl.network.annotations.Environment;
import xyz.nifeather.fmccl.network.annotations.EnvironmentType;
import xyz.nifeather.fmccl.network.commands.S2C.NetheriteS2CCommand;
import xyz.nifeather.fmccl.network.commands.S2C.query.NetheriteQueryType;

public class NetheriteS2CQueryCommand
extends NetheriteS2CCommand<String> {
    private final NetheriteQueryType netheriteQueryType;

    @Nullable
    public static NetheriteS2CQueryCommand from(String rawArg) {
        String[] spilt = rawArg.split(" ", 2);
        if (spilt.length < 1) {
            return null;
        }
        NetheriteQueryType type = NetheriteQueryType.tryValueOf(spilt[0].toUpperCase());
        return new NetheriteS2CQueryCommand(type, spilt.length == 2 ? spilt[1].split(" ") : new String[]{});
    }

    public NetheriteS2CQueryCommand(NetheriteQueryType netheriteQueryType, String ... diff) {
        super((T[])diff);
        this.netheriteQueryType = netheriteQueryType;
    }

    public NetheriteQueryType queryType() {
        return this.netheriteQueryType;
    }

    public List<String> getDiff() {
        return this.arguments;
    }

    @Override
    public String getBaseName() {
        return "query";
    }

    @Override
    public String buildCommand() {
        return this.getBaseName() + " " + this.netheriteQueryType.name().toLowerCase() + (String)(this.arguments.size() > 0 ? " " + this.serializeArguments() : "");
    }

    @Override
    @Environment(value=EnvironmentType.CLIENT)
    public void onCommand(BasicServerHandler<?> handler) {
        handler.onQueryCommand(this);
    }
}

