/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import java.util.Arrays;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.AttributeModifyOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.utilities.CommonUtils;

public class AttributeModifyingAbility
extends MorphAbility<AttributeModifyOption> {
    @NotNull
    public static final NamespacedKey modifierKey = Objects.requireNonNull(NamespacedKey.fromString((String)"feathermorph:ability_modifier"), "Bad server implementation");

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<AttributeModifyOption> optionHandler() {
        return AttributeModifyOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.ATTRIBUTE_MODIFY;
    }

    @Override
    public boolean applyToPlayer(Player player, DisguiseState state) {
        AttributeModifyOption option = (AttributeModifyOption)this.getOptionFor(state);
        if (option == null) {
            this.logger.error("No attribute modifier option found for %s!".formatted(state.getDisguiseIdentifier()));
            return false;
        }
        for (AttributeModifyOption.AttributeInfo modifierOption : option.modifiers) {
            AttributeInstance attributeInstance = this.getInstanceFor(player, modifierOption);
            if (attributeInstance == null) continue;
            AttributeModifier.Operation operationType = modifierOption.operationType.toBukkitOperation();
            if (operationType == null) {
                this.logger.warn("Modifier operation not set for attribute %s of disguise %s, ignoring...".formatted(modifierOption.attributeName, state.getDisguiseIdentifier()));
                continue;
            }
            AttributeModifier modifier = new AttributeModifier(modifierKey, modifierOption.value, operationType);
            attributeInstance.removeModifier((Key)modifierKey);
            attributeInstance.addTransientModifier(modifier);
        }
        return super.applyToPlayer(player, state);
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        return true;
    }

    @Override
    public boolean revokeFromPlayer(Player player, DisguiseState state) {
        if (!super.revokeFromPlayer(player, state)) {
            return false;
        }
        AttributeModifyOption option = (AttributeModifyOption)this.getOptionFor(state);
        if (option == null) {
            return true;
        }
        for (AttributeModifyOption.AttributeInfo attributeInfo : option.modifiers) {
            AttributeInstance attributeInstance = this.getInstanceFor(player, attributeInfo);
            if (attributeInstance == null) continue;
            attributeInstance.removeModifier((Key)modifierKey);
        }
        return true;
    }

    @Nullable
    private AttributeInstance getInstanceFor(Player player, AttributeModifyOption.AttributeInfo option) {
        if (!option.isValid()) {
            this.logger.error("Invalid attribute modifier option: " + String.valueOf(option));
            return null;
        }
        Attribute attribute = Arrays.stream(CommonUtils.getAvailableAttributes()).filter(a -> a.getKey().equals((Object)NamespacedKey.fromString((String)option.attributeName))).findFirst().orElse(null);
        if (attribute == null) {
            this.logger.error("No such modifier: " + option.attributeName);
            return null;
        }
        AttributeInstance attributeInstance = player.getAttribute(attribute);
        if (attributeInstance == null) {
            this.logger.error("No such instance for attribute: " + option.attributeName);
            return null;
        }
        return attributeInstance;
    }
}

