/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.phys.AABB;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.MorphAbility;
import xyz.nifeather.morph.abilities.options.HealsFromEntityOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.NmsRecord;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.set.S2CSetSNbtCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.utilities.DamageSourceUtils;
import xyz.nifeather.morph.utilities.EntityTypeUtils;
import xyz.nifeather.morph.utilities.NbtUtils;

public class HealsFromEntityAbility
extends MorphAbility<HealsFromEntityOption> {
    private final Random random = ThreadLocalRandom.current();
    private static final String PROPERTY_ID = "morph:HFEA_BEAM_TARGET";
    @Resolved
    private MorphClientHandler clientHandler;
    private final Map<String, net.minecraft.world.entity.EntityType<?>> stringEntityTypeMap = new Object2ObjectOpenHashMap();

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<HealsFromEntityOption> optionHandler() {
        return HealsFromEntityOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.HEALS_FROM_ENTITY;
    }

    private net.minecraft.world.entity.EntityType<?> getEntityType(String identifier) {
        net.minecraft.world.entity.EntityType cache = this.stringEntityTypeMap.getOrDefault(identifier, null);
        if (cache != null) {
            return cache;
        }
        cache = net.minecraft.world.entity.EntityType.byString((String)identifier).orElse(null);
        this.stringEntityTypeMap.put(identifier, cache);
        return cache;
    }

    @Override
    public boolean revokeFromPlayer(Player player, DisguiseState state) {
        if (!super.revokeFromPlayer(player, state)) {
            return false;
        }
        state.removeSessionData(PROPERTY_ID);
        return true;
    }

    @Override
    public boolean handle(Player player, DisguiseState state) {
        HealsFromEntityOption option = (HealsFromEntityOption)this.getOptionFor(state);
        if (option == null || !option.isValid()) {
            return false;
        }
        NmsRecord nmsRecord = NmsRecord.of(player);
        net.minecraft.world.entity.Entity beamTarget = state.getSessionData(PROPERTY_ID, net.minecraft.world.entity.Entity.class);
        if (beamTarget != null) {
            if (beamTarget.isAlive()) {
                double maxHealth = player.getMaxHealth();
                double playerHealth = player.getHealth();
                if (playerHealth > 0.0 && playerHealth / maxHealth < option.maxPercentage) {
                    player.setHealth(Math.min(maxHealth, playerHealth + option.healAmount));
                }
            } else {
                EntityDamageEvent lastDamageCause = beamTarget.getBukkitEntity().getLastDamageCause();
                if (lastDamageCause instanceof EntityDamageByEntityEvent) {
                    Projectile projectile;
                    Object source;
                    EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)lastDamageCause;
                    net.minecraft.world.entity.Entity damager = ((CraftEntity)entityDamageByEntityEvent.getDamager()).getHandle();
                    Entity entity = entityDamageByEntityEvent.getDamager();
                    if (entity instanceof Projectile && (source = (projectile = (Projectile)entity).getShooter()) instanceof CraftEntity) {
                        CraftEntity craftEntity = (CraftEntity)source;
                        damager = craftEntity.getHandle();
                    }
                    DamageSources sources = nmsRecord.nmsWorld().damageSources();
                    source = beamTarget.getType().equals(net.minecraft.world.entity.EntityType.END_CRYSTAL) ? sources.explosion(beamTarget, damager) : new DamageSource(sources.magic().typeHolder(), beamTarget, damager);
                    source = DamageSourceUtils.toNotScalable((DamageSource)source).bypassEverything().noSourceLocation();
                    nmsRecord.nmsPlayer().hurtServer(nmsRecord.nmsWorld(), (DamageSource)source, option.damageWhenDestroyed);
                }
                state.removeSessionData(PROPERTY_ID);
            }
        }
        if (this.random.nextInt(10) == 0) {
            net.minecraft.world.entity.EntityType<?> nmsType = EntityTypeUtils.getNmsType(state.getEntityType());
            if (nmsType == null) {
                this.logger.error("No such entity type: %s".formatted(option.entityIdentifier));
                return false;
            }
            net.minecraft.world.entity.Entity newEntity = this.findEntity(nmsRecord, nmsType, option.distance, option.entityType);
            if (!Objects.equals(beamTarget, newEntity)) {
                state.setSessionData(PROPERTY_ID, newEntity);
                if (state.getEntityType() == EntityType.ENDER_DRAGON) {
                    this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)this.getBeamCommand(state));
                }
            }
        }
        return true;
    }

    @Override
    public void onClientInit(DisguiseState state) {
        super.onClientInit(state);
        if (state.getEntityType() == EntityType.ENDER_DRAGON) {
            this.clientHandler.sendCommand(state.getPlayer(), (AbstractS2CCommand<?>)this.getBeamCommand(state));
        }
    }

    public S2CSetSNbtCommand getBeamCommand(DisguiseState state) {
        net.minecraft.world.entity.Entity entity = state.getSessionData(PROPERTY_ID, net.minecraft.world.entity.Entity.class);
        CompoundTag compound = new CompoundTag();
        compound.putInt("BeamTarget", entity != null ? entity.getId() : 0);
        return new S2CSetSNbtCommand(NbtUtils.getCompoundString(compound));
    }

    private net.minecraft.world.entity.Entity findEntity(NmsRecord record, net.minecraft.world.entity.EntityType<?> nmsType, double expand, EntityType bukkitType) {
        try {
            ServerLevel world = record.nmsWorld();
            ServerPlayer player = record.nmsPlayer();
            AABB boundingBox = nmsType.getDimensions().makeBoundingBox(player.position());
            Class<? extends net.minecraft.world.entity.Entity> classType = EntityTypeUtils.getNmsClass(bukkitType, record.nmsPlayer().getBukkitEntity().getWorld(), record.nmsPlayer().getBukkitEntity().getLocation());
            if (classType == null) {
                return null;
            }
            List entities = world.getEntitiesOfClass(classType, boundingBox.inflate(expand), e -> e.isAlive() && !e.isSpectator());
            net.minecraft.world.entity.Entity targetEntity = null;
            double distance = Double.MAX_VALUE;
            for (net.minecraft.world.entity.Entity entity : entities) {
                double dis = entity.distanceToSqr(player.position());
                if (!(dis < distance) || entity.getId() == player.getId()) continue;
                targetEntity = entity;
                distance = dis;
            }
            return targetEntity;
        }
        catch (Throwable t) {
            this.logger.error("Error finding entity around player %s".formatted(record.nmsPlayer()), t);
            return null;
        }
    }
}

