/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.impl.onAttack;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.abilities.impl.OnAttackAbility;
import xyz.nifeather.morph.abilities.options.ExtraKnockbackOption;
import xyz.nifeather.morph.api.morphs.abilities.AbilityNames;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class ExtraKnockbackAbility
extends OnAttackAbility<ExtraKnockbackOption> {
    @Resolved(shouldSolveImmediately=true)
    private MorphManager manager;
    private static final ExtraKnockbackOption defaultOption = ExtraKnockbackOption.from(0.0, 0.4, 0.0);

    @Override
    @NotNull
    public ISkillAbilityOptionHandler<ExtraKnockbackOption> optionHandler() {
        return ExtraKnockbackOption.OPTION_HANDLER;
    }

    @Override
    @NotNull
    public NamespacedKey getIdentifier() {
        return AbilityNames.EXTRA_KNOCKBACK;
    }

    @Override
    protected void onAttack(org.bukkit.entity.LivingEntity damaged, Player player) {
        Entity nmsDamaged = ((CraftEntity)damaged).getHandle();
        DisguiseState state = this.manager.getDisguiseStateFor(player);
        assert (state != null);
        ExtraKnockbackOption option = (ExtraKnockbackOption)this.getOptionFor(state);
        if (option == null) {
            option = defaultOption;
        }
        double yDelta = option.yMotion;
        double baseYDelta = 0.345584025;
        if (nmsDamaged instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)nmsDamaged;
            double knockbackResistance = livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
            yDelta *= Math.max(0.0, 1.0 - knockbackResistance);
            baseYDelta *= Math.max(0.0, 1.0 - knockbackResistance);
        }
        yDelta = baseYDelta + yDelta;
        Vec3 movement = nmsDamaged.getDeltaMovement().add(option.xMotion, yDelta, option.zMotion);
        nmsDamaged.setPos(nmsDamaged.position().add(0.0, 0.01, 0.0));
        nmsDamaged.setOnGround(false);
        nmsDamaged.setDeltaMovement(movement);
        nmsDamaged.hasImpulse = true;
    }
}

