/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.abilities.options;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.abilities.ISkillAbilityOptionHandler;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.storage.skill.ISkillAbilityOption;

public class BossbarOption
implements ISkillAbilityOption {
    public static final BossbarOptionHandler OPTION_HANDLER = new BossbarOptionHandler();
    private final int applyDistance;
    private final BossbarCreateOption createOption;

    public BossbarOption(BossbarCreateOption option, int distance) {
        this.createOption = option;
        this.applyDistance = distance;
    }

    public int getApplyDistance() {
        return this.applyDistance;
    }

    public BossbarCreateOption getCreateOption() {
        return this.createOption;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public record BossbarCreateOption(String name, BossBar.Color color, BossBar.Overlay overlay, Set<BossBar.Flag> flags) {
    }

    public static class BossbarOptionHandler
    implements ISkillAbilityOptionHandler<BossbarOption> {
        @Override
        public Class<BossbarOption> getOptionClass() {
            return BossbarOption.class;
        }

        @Override
        public void writeOption(BossbarOption option, @NotNull Map<String, Object> gsonMap) {
            BossbarCreateOption createOption = option.getCreateOption();
            if (createOption != null) {
                gsonMap.put("color", createOption.color.name().toLowerCase());
                gsonMap.put("style", createOption.overlay().name().toLowerCase());
                gsonMap.put("name", createOption.name());
                ObjectArrayList flags = new ObjectArrayList();
                createOption.flags().forEach(arg_0 -> BossbarOptionHandler.lambda$writeOption$0((List)flags, arg_0));
                gsonMap.put("flags", flags);
            }
            gsonMap.put("distance", option.applyDistance);
        }

        @Override
        @NotNull
        public BossbarOption readOption(@NotNull Map<String, Object> gsonMap) throws ParseErrorException {
            String colorString = this.utilGetTypedOrThrow("color", gsonMap, String.class);
            String styleString = this.utilGetTypedOrThrow("style", gsonMap, String.class);
            String name = this.utilGetTypedOrThrow("name", gsonMap, String.class);
            int distance = this.utilGetTypedOrThrow("distance", gsonMap, Number.class).intValue();
            BossBar.Color color = (BossBar.Color)InputHandles.readEnumNonNull((Enum[])BossBar.Color.values(), (String)"color", (String)colorString).orElseThrow(() -> new ParseErrorException("color", "No value match for bossbar color '%s'".formatted(colorString)));
            BossBar.Overlay style = (BossBar.Overlay)InputHandles.readEnumNonNull((Enum[])BossBar.Overlay.values(), (String)"style", (String)styleString).orElseThrow(() -> new ParseErrorException("style", "No value match for bossbar style '%s'".formatted(styleString)));
            List<Object> rawFlagList = this.utilGetTypedOrThrow("flags", gsonMap, List.class).stream().map(Object::toString).toList();
            String clazzSimpleName = this.getClass().getSimpleName();
            ObjectArraySet flags = new ObjectArraySet();
            for (String string : rawFlagList) {
                BossBar.Flag flag = (BossBar.Flag)InputHandles.readEnumNonNull((Enum[])BossBar.Flag.values(), (String)clazzSimpleName, (String)string).orElseThrow(() -> new ParseErrorException(clazzSimpleName, "No matching bossbar flag for input '%s'".formatted(input)));
                flags.add(flag);
            }
            BossbarCreateOption createOption = new BossbarCreateOption(name, color, style, (Set<BossBar.Flag>)flags);
            return new BossbarOption(createOption, distance);
        }

        private static /* synthetic */ void lambda$writeOption$0(List flags, BossBar.Flag f) {
            flags.add(f.name().toLowerCase());
        }
    }
}

