/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.EnderDragonProperties;

public class EnderDragonWatcher
extends LivingEntityWatcher {
    private final EnderDragonProperties properties = DisguiseProperties.INSTANCE.getOrThrow(EnderDragonProperties.class);

    public EnderDragonWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.ENDER_DRAGON);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.ENDER_DRAGON);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        if (Objects.equals(property, this.properties.DRAGON_PHASE)) {
            this.writePersistent(ValueIndex.ENDER_DRAGON.DRAGON_PHASE, (Integer)value);
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        nbt.putInt("DragonPhase", this.read(ValueIndex.ENDER_DRAGON.DRAGON_PHASE).intValue());
        super.writeToCompound(nbt);
    }

    @Override
    @Nullable
    public <X> X readEntry(CustomEntry<X> entry) {
        if (Objects.equals(entry, CustomEntries.OVERLAYED_YAW)) {
            return (X)Float.valueOf(180.0f + this.getBindingPlayer().getYaw());
        }
        return super.readEntry(entry);
    }
}

