/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.Equipment;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityEquipment;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.PacketFactory;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class EquipmentPacketListener
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;
    private final Map<Player, Boolean> alreadyFake = new Object2ObjectOpenHashMap();

    public EquipmentPacketListener() {
        this.registry.onUnRegister(this, parameters -> this.alreadyFake.remove(parameters.player()));
    }

    @Override
    public String getIdentifier() {
        return "equip_listener";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.ENTITY_EQUIPMENT) {
            return;
        }
        WrapperPlayServerEntityEquipment wrapper = new WrapperPlayServerEntityEquipment(event);
        this.onEquipmentPacket(wrapper, event);
    }

    private void onEquipmentPacket(WrapperPlayServerEntityEquipment packet, PacketSendEvent event) {
        if (PacketFactory.isEquipmentPacketOurs(packet)) {
            packet.setEntityId(Math.abs(packet.getEntityId()));
            return;
        }
        Player sourcePlayer = this.getPlayerFrom(packet.getEntityId());
        if (sourcePlayer == null) {
            return;
        }
        SingleWatcher watcher = this.registry.getWatcher(sourcePlayer.getUniqueId());
        if (watcher == null) {
            return;
        }
        if (!watcher.readEntryOrDefault(CustomEntries.DISPLAY_FAKE_EQUIPMENT, false).booleanValue()) {
            this.alreadyFake.remove(sourcePlayer);
            return;
        }
        if (this.alreadyFake.getOrDefault(sourcePlayer, false).booleanValue()) {
            event.setCancelled(true);
            return;
        }
        event.markForReEncode(true);
        List<Equipment> equipments = PacketFactory.getPacketeventsEquipments(sourcePlayer, watcher);
        packet.setEquipment(equipments);
        this.alreadyFake.put(sourcePlayer, true);
    }
}

