/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.messages.CommandStrings;
import xyz.nifeather.morph.messages.EmoteStrings;
import xyz.nifeather.morph.messages.HelpStrings;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.gui.AnimSelectScreenWrapper;
import xyz.nifeather.morph.providers.animation.AnimationSet;
import xyz.nifeather.morph.providers.animation.SingleAnimation;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class AnimationCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved
    private MorphManager morphManager;

    @Override
    public String name() {
        return "play-action";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.animationDescription();
    }

    @Override
    public boolean register(Commands dispatcher) {
        dispatcher.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).executes(this::executeOpenGui)).then(Commands.argument((String)"action", (ArgumentType)StringArgumentType.greedyString()).suggests(this::suggests).executes(this::execWithArg))).build());
        return IConvertibleBrigadier.super.register(dispatcher);
    }

    @NotNull
    public CompletableFuture<Suggestions> suggests(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        Entity source = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(source instanceof Player)) {
            return CompletableFuture.completedFuture(suggestionsBuilder.build());
        }
        Player player = (Player)source;
        DisguiseState state = this.morphManager.getDisguiseStateFor(player);
        if (state == null) {
            return CompletableFuture.completedFuture(suggestionsBuilder.build());
        }
        List<String> animations = state.getProvider().getAnimationProvider().getAnimationSetFor(state.getDisguiseIdentifier()).getAvailableAnimationsForClient();
        String name = suggestionsBuilder.getRemainingLowerCase();
        return CompletableFuture.supplyAsync(() -> {
            animations.stream().filter(id -> id.startsWith(name)).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
            return suggestionsBuilder.build();
        });
    }

    public int executeOpenGui(CommandContext<CommandSourceStack> context) {
        Entity commandSender = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(commandSender instanceof Player)) {
            return 1;
        }
        Player player = (Player)commandSender;
        DisguiseState state = this.morphManager.getDisguiseStateFor(player);
        if (state == null) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.notDisguised()));
            return 1;
        }
        AnimationSet animationSet = state.getProvider().getAnimationProvider().getAnimationSetFor(state.getDisguiseIdentifier());
        AnimSelectScreenWrapper screen = new AnimSelectScreenWrapper(state, animationSet.getAvailableAnimationsForClient());
        screen.show();
        return 1;
    }

    private int execWithArg(CommandContext<CommandSourceStack> context) {
        Entity commandSender = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(commandSender instanceof Player)) {
            return 1;
        }
        Player player = (Player)commandSender;
        DisguiseState state = this.morphManager.getDisguiseStateFor(player);
        if (state == null) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.notDisguised()));
            return 1;
        }
        AnimationSet animationSet = state.getProvider().getAnimationProvider().getAnimationSetFor(state.getDisguiseIdentifier());
        String animationId = StringArgumentType.getString(context, (String)"action");
        List<String> animations = animationSet.getAvailableAnimationsForClient();
        if (!animations.contains(animationId)) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, CommandStrings.noSuchAnimation()));
            return 1;
        }
        Pair<List<SingleAnimation>, Boolean> sequencePair = animationSet.sequenceOf(animationId);
        if (!state.tryScheduleSequence(animationId, (List)sequencePair.left(), (Boolean)sequencePair.right())) {
            player.sendMessage(MessageUtils.prefixes((CommandSender)player, EmoteStrings.notAvailable()));
        }
        return 1;
    }
}

